/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.carryonextend.handler;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.prizowo.carryonextend.network.PlayerThrowPacket;
import net.prizowo.carryonextend.trigger.TriggerRegistry;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.networking.PacketBase;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.platform.Services;

public class EntityThrowHandler {
    private static final float BASE_THROW_POWER = 0.8f;
    private static final float BASE_THROW_UPWARD = 0.2f;
    private static final float MAX_POWER_MULTIPLIER = 2.5f;
    private static final float PLAYER_THROW_POWER_BONUS = 1.2f;
    private static final float PLAYER_THROW_UPWARD_BONUS = 0.6f;

    public static void throwCarriedEntity(ServerPlayer player) {
        EntityThrowHandler.throwCarriedEntityWithPower(player, 1.0f);
    }

    public static void throwCarriedEntityWithPower(ServerPlayer player, float powerFactor) {
        CarryOnScript.ScriptEffects effects;
        String cmd;
        Entity passenger;
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (!carry.isCarrying(CarryOnData.CarryType.ENTITY) && !carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            return;
        }
        Level level = player.level();
        float powerMult = 1.0f + powerFactor * 1.5f;
        float throwPower = 0.8f * powerMult;
        float throwUpward = 0.2f * powerMult;
        if (carry.isCarrying(CarryOnData.CarryType.PLAYER) && (passenger = player.getFirstPassenger()) != null) {
            Vec3 lookDir = player.getLookAngle();
            Vec3 playerPos = player.position().add(lookDir.multiply(2.0, 0.0, 2.0)).add(0.0, 1.5, 0.0);
            float playerThrowPower = throwPower + 1.2f;
            float playerThrowUpward = throwUpward + 0.6f;
            Vec3 velocity = new Vec3(lookDir.x * (double)playerThrowPower, (double)playerThrowUpward, lookDir.z * (double)playerThrowPower);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                List allPlayers = serverLevel.getServer().getPlayerList().getPlayers();
                for (ServerPlayer serverPlayer : allPlayers) {
                    Services.PLATFORM.sendPacketToPlayer(Constants.PACKET_ID_START_RIDING, (PacketBase)new ClientboundStartRidingPacket(passenger.getId(), false), serverPlayer);
                }
            }
            carry.clear();
            CarryOnDataManager.setCarryData((Player)player, (CarryOnData)carry);
            passenger.stopRiding();
            player.ejectPassengers();
            passenger.setPos(playerPos);
            if (passenger instanceof ServerPlayer) {
                ServerPlayer thrownPlayer = (ServerPlayer)passenger;
                thrownPlayer.connection.teleport(playerPos.x, playerPos.y, playerPos.z, thrownPlayer.getYRot(), thrownPlayer.getXRot());
                PacketDistributor.sendToPlayer((ServerPlayer)thrownPlayer, (CustomPacketPayload)new PlayerThrowPacket(velocity.x, velocity.y, velocity.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                passenger.setDeltaMovement(velocity);
            }
            float pitch = Math.max(0.5f, Math.min(1.8f, 0.8f + powerFactor * 0.8f));
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 0.8f, pitch);
            player.swing(InteractionHand.MAIN_HAND, true);
            return;
        }
        CompoundTag entityNBT = carry.getContentNbt();
        if (entityNBT == null) {
            carry.clear();
            CarryOnDataManager.setCarryData((Player)player, (CarryOnData)carry);
            return;
        }
        Entity entity = carry.getEntity(level);
        if (entity instanceof PrimedTnt) {
            PrimedTnt primedTnt = (PrimedTnt)entity;
            TriggerRegistry.TNT_THROW.get().trigger(player);
            primedTnt.addTag("thrownBy:" + player.getUUID().toString());
        }
        Vec3 playerPos = player.position().add(0.0, 1.0, 0.0);
        entity.setPos(playerPos);
        if (carry.getActiveScript().isPresent() && !(cmd = (effects = ((CarryOnScript)carry.getActiveScript().get()).scriptEffects()).commandPlace()).isEmpty()) {
            player.getServer().getCommands().performPrefixedCommand(player.getServer().createCommandSourceStack(), "/execute as " + player.getGameProfile().getName() + " run " + cmd);
        }
        level.addFreshEntity(entity);
        Vec3 lookDir = player.getLookAngle();
        entity.setDeltaMovement(lookDir.x * (double)throwPower, (double)throwUpward, lookDir.z * (double)throwPower);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.setNoAi(false);
        }
        float pitch = Math.max(0.5f, Math.min(1.8f, 0.8f + powerFactor * 0.8f));
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 0.8f, pitch);
        carry.clear();
        CarryOnDataManager.setCarryData((Player)player, (CarryOnData)carry);
        player.swing(InteractionHand.MAIN_HAND, true);
    }
}

