/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.carryonextend.registry;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.prizowo.carryonextend.util.FallingBlockEntityUtil;
import org.jetbrains.annotations.NotNull;

public class CustomFallingBlockEntity
extends FallingBlockEntity {
    private static final EntityDataAccessor<CompoundTag> BLOCK_DATA = SynchedEntityData.defineId(CustomFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private boolean shouldDropItems = false;
    private boolean handledDrops = false;
    private BlockState cachedBlockState = null;

    public CustomFallingBlockEntity(EntityType<CustomFallingBlockEntity> type, Level level) {
        super(type, level);
    }

    public static CustomFallingBlockEntity throwBlock(Level level, double x, double y, double z, BlockState state, CompoundTag blockData, Vec3 motion) {
        return FallingBlockEntityUtil.throwBlock(level, x, y, z, state, blockData, motion);
    }

    public void setCachedBlockState(BlockState state) {
        this.cachedBlockState = state;
    }

    public void setDropItem(boolean dropItem) {
        this.dropItem = dropItem;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BLOCK_DATA, (Object)new CompoundTag());
    }

    public void setBlockData(CompoundTag blockData) {
        this.entityData.set(BLOCK_DATA, (Object)blockData);
    }

    public CompoundTag getBlockData() {
        return (CompoundTag)this.entityData.get(BLOCK_DATA);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("CustomBlockData", (Tag)this.getBlockData());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("CustomBlockData")) {
            this.setBlockData(tag.getCompound("CustomBlockData"));
        }
    }

    public void tick() {
        CompoundTag customData = this.getBlockData();
        BlockState blockState = FallingBlockEntityUtil.getBlockState(this);
        if (blockState == null && this.cachedBlockState != null) {
            blockState = this.cachedBlockState;
            FallingBlockEntityUtil.setBlockState(this, this.cachedBlockState);
        }
        if (blockState == null) {
            this.discard();
            return;
        }
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        BlockPos pos = this.blockPosition();
        if (!this.level().isClientSide) {
            if (this.isRemoved()) {
                return;
            }
            boolean canPlace = this.level().getBlockState(pos).canBeReplaced();
            boolean onGround = this.onGround();
            if (onGround && canPlace) {
                if (FallingBlockEntityUtil.placeBlock(this, pos, blockState, customData, this.level())) {
                    return;
                }
            } else if (onGround && !this.handledDrops) {
                if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    ItemStack itemStack = FallingBlockEntityUtil.createItemWithBlockEntityData(blockState, customData, pos, this.level());
                    this.spawnAtLocation(itemStack);
                    this.handledDrops = true;
                }
                this.discard();
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
    }
}

