/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.carryonextend.util;

import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.prizowo.carryonextend.CarryOnExtend;
import net.prizowo.carryonextend.registry.CustomFallingBlockEntity;
import net.prizowo.carryonextend.registry.EntityRegistry;

public class FallingBlockEntityUtil {
    private static Field blockStateField;
    private static Field cancelDropField;
    private static Field timeField;

    public static CustomFallingBlockEntity throwBlock(Level level, double x, double y, double z, BlockState state, CompoundTag blockData, Vec3 motion) {
        CustomFallingBlockEntity entity = new CustomFallingBlockEntity(EntityRegistry.CUSTOM_FALLING_BLOCK.get(), level);
        entity.setPos(x, y, z);
        entity.setCachedBlockState(state);
        try {
            if (blockStateField != null) {
                blockStateField.set((Object)entity, state);
            }
        }
        catch (IllegalAccessException e) {
            return null;
        }
        entity.setBlockData(blockData);
        entity.setDeltaMovement(motion);
        FallingBlockEntityUtil.setEntityTime(entity, 1);
        entity.setDropItem(true);
        level.addFreshEntity((Entity)entity);
        return entity;
    }

    public static BlockState getBlockState(FallingBlockEntity entity) {
        try {
            if (blockStateField != null) {
                return (BlockState)blockStateField.get(entity);
            }
        }
        catch (IllegalAccessException e) {
            CarryOnExtend.LOGGER.error("Unable to obtain the blockState of FallingBlockEntity", (Throwable)e);
        }
        return null;
    }

    public static boolean setBlockState(FallingBlockEntity entity, BlockState state) {
        try {
            if (blockStateField != null) {
                blockStateField.set(entity, state);
                return true;
            }
        }
        catch (IllegalAccessException e) {
            CarryOnExtend.LOGGER.error("Unable to set blockState for FallingBlockEntity", (Throwable)e);
        }
        return false;
    }

    public static void setEntityTime(FallingBlockEntity entity, int time) {
        try {
            if (timeField != null) {
                timeField.set(entity, time);
            }
        }
        catch (IllegalAccessException e) {
            CarryOnExtend.LOGGER.error("Unable to set the time field of FallingBlockEntity", (Throwable)e);
        }
    }

    public static boolean placeBlock(CustomFallingBlockEntity entity, BlockPos pos, BlockState state, CompoundTag blockData, Level level) {
        if (level.setBlock(pos, state, 3)) {
            if (level.getBlockEntity(pos) != null && blockData != null && !blockData.isEmpty()) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity != null && blockEntity.getLevel() == null) {
                    blockEntity.setLevel(level);
                }
                blockEntity.loadWithComponents(blockData, (HolderLookup.Provider)level.registryAccess());
                level.sendBlockUpdated(pos, state, state, 3);
                blockEntity.setChanged();
            }
            entity.discard();
            return true;
        }
        return false;
    }

    public static ItemStack createItemWithBlockEntityData(BlockState state, CompoundTag blockData, BlockPos pos, Level level) {
        EntityBlock entityBlock;
        BlockEntity tempEntity;
        Block block;
        ItemStack itemStack = new ItemStack((ItemLike)state.getBlock());
        if (blockData != null && !blockData.isEmpty() && (block = state.getBlock()) instanceof EntityBlock && (tempEntity = (entityBlock = (EntityBlock)block).newBlockEntity(pos, state)) != null) {
            tempEntity.setLevel(level);
            tempEntity.loadWithComponents(blockData, (HolderLookup.Provider)level.registryAccess());
            tempEntity.saveToItem(itemStack, (HolderLookup.Provider)level.registryAccess());
        }
        return itemStack;
    }

    public static boolean hasBlockDataTag(CustomFallingBlockEntity entity, String key) {
        CompoundTag blockData = entity.getBlockData();
        return blockData != null && blockData.contains(key);
    }

    public static CompoundTag getBlockDataTag(CustomFallingBlockEntity entity, String key) {
        CompoundTag blockData = entity.getBlockData();
        if (blockData != null && blockData.contains(key, 10)) {
            return blockData.getCompound(key);
        }
        return null;
    }

    static {
        try {
            blockStateField = FallingBlockEntity.class.getDeclaredField("blockState");
            blockStateField.setAccessible(true);
            cancelDropField = FallingBlockEntity.class.getDeclaredField("cancelDrop");
            cancelDropField.setAccessible(true);
            timeField = FallingBlockEntity.class.getDeclaredField("time");
            timeField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            CarryOnExtend.LOGGER.error("Unable to retrieve the blockState field of FallingBlockEntity", (Throwable)e);
        }
    }
}

