/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.quad;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import xfacthd.framedblocks.api.model.quad.QuadData;
import xfacthd.framedblocks.api.model.util.ModelUtils;

public final class QuadModifier {
    private static final QuadModifier FAILED = new QuadModifier(null, -1, false, false, false, true);
    private final QuadData data;
    private int tintIndex;
    private boolean shade;
    private boolean ao;
    private boolean modified;
    private boolean failed;
    private boolean exported;

    public static QuadModifier of(BakedQuad quad) {
        return new QuadModifier(new QuadData(quad), -1, quad.isShade(), quad.hasAmbientOcclusion(), false, false);
    }

    private QuadModifier(QuadData data, int tintIndex, boolean shade, boolean ao, boolean modified, boolean failed) {
        this.data = data;
        this.tintIndex = tintIndex;
        this.shade = shade;
        this.ao = ao;
        this.modified = modified;
        this.failed = failed;
    }

    public QuadModifier applyIf(Modifier modifier, boolean apply) {
        return apply ? this.apply(modifier) : this;
    }

    public QuadModifier apply(Modifier modifier) {
        if (!this.failed) {
            if (this.exported) {
                throw new IllegalStateException("QuadModifier has been exported, no further modifications allowed without deriving");
            }
            this.failed = !modifier.accept(this.data);
            this.modified = true;
        }
        return this;
    }

    public QuadModifier tintIndex(int tintIndex) {
        Preconditions.checkState((this.tintIndex == -1 ? 1 : 0) != 0, (Object)"TintIndex has already been set");
        this.tintIndex = tintIndex;
        this.modified = true;
        return this;
    }

    public QuadModifier shade(boolean shade) {
        if (shade != this.data.quad.isShade()) {
            this.shade = shade;
            this.modified = true;
        }
        return this;
    }

    public QuadModifier ambientOcclusion(boolean ao) {
        if (ao != this.data.quad.hasAmbientOcclusion()) {
            this.ao = ao;
            this.modified = true;
        }
        return this;
    }

    public void export(List<BakedQuad> quadList) {
        if (this.failed) {
            return;
        }
        if (!this.modified) {
            quadList.add(this.data.quad);
            return;
        }
        BakedQuad newQuad = new BakedQuad(this.data.vertexData, this.tintIndex == -1 ? this.data.quad.getTintIndex() : this.tintIndex, ModelUtils.fillNormal(this.data), this.data.quad.getSprite(), this.shade, this.ao);
        quadList.add(newQuad);
        this.exported = true;
    }

    public void modifyInPlace() {
        Preconditions.checkState((this.tintIndex == -1 ? 1 : 0) != 0, (Object)"In-place modification can't change tintIndex but a tintIndex has been set");
        Preconditions.checkState((this.shade == this.data.quad.isShade() ? 1 : 0) != 0, (Object)"In-place modification can't change shading but shade has been modified");
        Preconditions.checkState((this.ao == this.data.quad.hasAmbientOcclusion() ? 1 : 0) != 0, (Object)"In-place modification can't change AO but AO has been modified");
        if (this.failed) {
            return;
        }
        ModelUtils.fillNormal(this.data);
        System.arraycopy(this.data.vertexData, 0, this.data.quad.getVertices(), 0, this.data.vertexData.length);
        this.exported = true;
    }

    public QuadModifier derive() {
        if (this.failed) {
            return FAILED;
        }
        return new QuadModifier(new QuadData(this.data), this.tintIndex, this.shade, this.ao, this.modified, false);
    }

    public boolean hasFailed() {
        return this.failed;
    }

    @FunctionalInterface
    public static interface Modifier {
        public boolean accept(QuadData var1);
    }
}

