/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.model.quad.QuadData;
import xfacthd.framedblocks.api.util.ConfigView;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.mixin.client.AccessorWeightedBakedModel;

public final class ModelUtils {
    private static final Direction[] DIRECTIONS = Direction.values();
    public static final ChunkRenderTypeSet SOLID = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.solid()});
    public static final ChunkRenderTypeSet CUTOUT = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout()});
    public static final ChunkRenderTypeSet TRANSLUCENT = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.translucent()});
    public static final float UV_SUBSTEP_COUNT = 128.0f;

    public static Direction fillNormal(QuadData data) {
        Vector3f v1 = data.pos(3, new Vector3f());
        Vector3f t1 = data.pos(1, new Vector3f());
        Vector3f v2 = data.pos(2, new Vector3f());
        Vector3f t2 = data.pos(0, new Vector3f());
        v1.sub((Vector3fc)t1);
        v2.sub((Vector3fc)t2);
        v2.cross((Vector3fc)v1);
        v2.normalize();
        for (int vert = 0; vert < 4; ++vert) {
            data.normal(vert, v2);
        }
        return Direction.getNearest((float)v2.x, (float)v2.y, (float)v2.z);
    }

    @Deprecated(forRemoval=true)
    public static void remapUV(Direction quadDir, TextureAtlasSprite sprite, float coord1, float coord2, float coordTo, QuadData data, int uv1, int uv2, int uvTo, boolean vAxis, boolean invert, boolean rotated, boolean mirrored) {
        ModelUtils.remapUV(sprite, data, coord1, coord2, coordTo, uv1, uv2, uvTo, vAxis, rotated);
    }

    public static void remapUV(TextureAtlasSprite sprite, QuadData data, float coord1, float coord2, float coordTo, int uv1, int uv2, int uvTo, boolean vAxis, boolean rotated) {
        boolean invert;
        float coordMin = Math.min(coord1, coord2);
        float coordMax = Math.max(coord1, coord2);
        int uvIdx = rotated != vAxis ? 1 : 0;
        float uvAbs1 = data.uv(uv1, uvIdx);
        float uvAbs2 = data.uv(uv2, uvIdx);
        float uvAbsMin = Math.min(uvAbs1, uvAbs2);
        float uvAbsMax = Math.max(uvAbs1, uvAbs2);
        boolean bl = invert = (coord2 > coord1 ^ uvAbs2 > uvAbs1) != vAxis;
        if (coordTo == coordMin) {
            data.uv(uvTo, uvIdx, invert ? uvAbsMax : uvAbsMin);
        } else if (coordTo == coordMax) {
            data.uv(uvTo, uvIdx, invert ? uvAbsMin : uvAbsMax);
        } else if (ConfigView.Client.INSTANCE.useDiscreteUVSteps()) {
            float uvRelMin = uvIdx == 0 ? sprite.getUOffset(uvAbsMin) : sprite.getVOffset(uvAbsMin);
            float uvRelMax = uvIdx == 0 ? sprite.getUOffset(uvAbsMax) : sprite.getVOffset(uvAbsMax);
            float mult = (coordTo - coordMin) / (coordMax - coordMin);
            if (invert) {
                mult = 1.0f - mult;
            }
            float uvRelTo = Mth.lerp((float)mult, (float)uvRelMin, (float)uvRelMax);
            uvRelTo = (float)Math.round(uvRelTo * 128.0f) / 128.0f;
            data.uv(uvTo, uvIdx, uvIdx == 0 ? sprite.getU(uvRelTo) : sprite.getV(uvRelTo));
        } else {
            float mult = (coordTo - coordMin) / (coordMax - coordMin);
            if (invert) {
                mult = 1.0f - mult;
            }
            data.uv(uvTo, uvIdx, Mth.lerp((float)mult, (float)uvAbsMin, (float)uvAbsMax));
        }
    }

    public static boolean isQuadRotated(QuadData data) {
        return !(!Mth.equal((float)data.uv(0, 1), (float)data.uv(1, 1)) && !Mth.equal((float)data.uv(3, 1), (float)data.uv(2, 1)) || !Mth.equal((float)data.uv(1, 0), (float)data.uv(2, 0)) && !Mth.equal((float)data.uv(0, 0), (float)data.uv(3, 0)));
    }

    public static boolean isQuadMirrored(QuadData data, boolean rotated) {
        if (!rotated) {
            return data.uv(0, 0) > data.uv(3, 0) && data.uv(1, 0) > data.uv(2, 0) || data.uv(0, 1) > data.uv(1, 1) && data.uv(3, 1) > data.uv(2, 1);
        }
        return data.uv(0, 0) > data.uv(1, 0) && data.uv(3, 0) > data.uv(2, 0) || data.uv(0, 1) < data.uv(3, 1) && data.uv(1, 1) < data.uv(2, 1);
    }

    public static BakedQuad invertTintIndex(BakedQuad quad) {
        if (quad.getTintIndex() == -1) {
            return quad;
        }
        return new BakedQuad(quad.getVertices(), ModelUtils.encodeSecondaryTintIndex(quad.getTintIndex()), quad.getDirection(), quad.getSprite(), quad.isShade());
    }

    public static int encodeSecondaryTintIndex(int tintIndex) {
        return (tintIndex + 2) * -1;
    }

    public static int decodeSecondaryTintIndex(int tintIndex) {
        return tintIndex * -1 - 2;
    }

    public static ModelData getCamoModelData(ModelData data) {
        ModelData camoData = (ModelData)data.get(FramedBlockData.CAMO_DATA);
        return camoData != null ? camoData : ModelData.EMPTY;
    }

    public static BakedModel getModel(BlockState state) {
        return Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
    }

    public static ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource random, ModelData data) {
        return ModelUtils.getModel(state).getRenderTypes(state, random, data);
    }

    public static ArrayList<BakedQuad> getCullableQuads(BakedModel model, BlockState state, RandomSource rand, ModelData data, RenderType renderType, Predicate<Direction> filter) {
        if (model instanceof WeightedBakedModel) {
            WeightedBakedModel weighted = (WeightedBakedModel)model;
            model = ((AccessorWeightedBakedModel)weighted).framedblocks$getWrappedModel();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction dir : DIRECTIONS) {
            if (!filter.test(dir)) continue;
            List<BakedQuad> sideQuads = model.getQuads(state, dir, rand, data, renderType);
            if (sideQuads.isEmpty()) {
                sideQuads = ModelUtils.getFilteredNullQuads(model, state, rand, data, renderType, dir);
            }
            Utils.copyAll(sideQuads, quads);
        }
        return quads;
    }

    public static List<BakedQuad> getFilteredNullQuads(BakedModel model, BlockState state, RandomSource rand, ModelData data, @Nullable RenderType renderType, Direction side) {
        List nullQuads = model.getQuads(state, null, rand, data, renderType);
        if (nullQuads.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> filtered = new ArrayList<BakedQuad>();
        for (int i = 0; i < nullQuads.size(); ++i) {
            boolean aligned;
            BakedQuad quad = (BakedQuad)nullQuads.get(i);
            if (quad.getDirection() != side) continue;
            float minX = 32.0f;
            float minY = 32.0f;
            float minZ = 32.0f;
            float maxX = -32.0f;
            float maxY = -32.0f;
            float maxZ = -32.0f;
            int[] vertexData = quad.getVertices();
            for (int vert = 0; vert < 4; ++vert) {
                int offset = vert * IQuadTransformer.STRIDE + IQuadTransformer.POSITION;
                float x = Float.intBitsToFloat(vertexData[offset]);
                float y = Float.intBitsToFloat(vertexData[offset + 1]);
                float z = Float.intBitsToFloat(vertexData[offset + 2]);
                minX = Math.min(minX, x);
                minY = Math.min(minY, y);
                minZ = Math.min(minZ, z);
                maxX = Math.max(maxX, x);
                maxY = Math.max(maxY, y);
                maxZ = Math.max(maxZ, z);
            }
            boolean positive = Utils.isPositive(side);
            switch (side.getAxis()) {
                default: {
                    throw new MatchException(null, null);
                }
                case X: {
                    boolean bl;
                    if (minX == maxX && (positive ? maxX > 0.9999f : minX < 1.0E-4f)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case Y: {
                    boolean bl;
                    if (minY == maxY && (positive ? maxY > 0.9999f : minY < 1.0E-4f)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case Z: {
                    boolean bl = minZ == maxZ && (positive ? maxZ > 0.9999f : minZ < 1.0E-4f) ? true : (aligned = false);
                }
            }
            if (!aligned) continue;
            filtered.add(quad);
        }
        return filtered;
    }

    private ModelUtils() {
    }
}

