/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.prism;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;

public class FramedSlopedPrismGeometry
extends Geometry {
    private final Direction facing;
    private final Direction orientation;
    private final boolean ySlope;

    public FramedSlopedPrismGeometry(GeometryFactory.Context ctx) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)ctx.state().getValue(PropertyHolder.FACING_DIR));
        this.facing = cmpDir.direction();
        this.orientation = cmpDir.orientation();
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        boolean yFacing = Utils.isY(this.facing);
        boolean yOrient = Utils.isY(this.orientation);
        Direction orientOpp = this.orientation.getOpposite();
        Direction quadFace = quad.getDirection();
        if (quadFace == orientOpp && !yOrient) {
            if (!yFacing) {
                QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.facing)).apply(Modifiers.makeHorizontalSlope(this.orientation == this.facing.getClockWise(), 45.0f)).export(quadMap.get(null));
            } else if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.facing)).apply(Modifiers.makeVerticalSlope(this.facing == Direction.UP, 45.0f)).export(quadMap.get(null));
            }
        } else if (this.ySlope && yFacing && Utils.isY(quadFace)) {
            QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.orientation)).apply(Modifiers.makeVerticalSlope(orientOpp, 45.0f)).export(quadMap.get(null));
            Direction offAxisCW = this.orientation.getClockWise();
            Direction offAxisCCW = this.orientation.getCounterClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(offAxisCW, 0.5f)).apply(Modifiers.cutTopBottom(orientOpp, 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(offAxisCCW, 45.0f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(offAxisCCW, 0.5f)).apply(Modifiers.cutTopBottom(orientOpp, 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(offAxisCW, 45.0f)).export(quadMap.get(null));
        } else if (!this.ySlope && yOrient && quadFace == this.facing) {
            QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.orientation)).apply(Modifiers.makeVerticalSlope(this.orientation == Direction.DOWN, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && yOrient && quadFace == orientOpp) {
            QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.facing)).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
        } else if (quadFace == this.orientation) {
            QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.facing)).export(quadMap.get(quadFace));
        } else if (!this.ySlope && yFacing && quadFace.getAxis() == this.orientation.getClockWise().getAxis()) {
            boolean up = this.facing == Direction.UP;
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.getOpposite(), up ? 0.0f : 1.0f, up ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
        } else if (yOrient && quadFace.getAxis() == this.facing.getClockWise().getAxis()) {
            boolean right = quadFace == this.facing.getClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing, 0.5f)).apply(Modifiers.cutSideUpDown(this.orientation == Direction.UP, right ? 1.0f : 0.0f, right ? 0.0f : 1.0f)).apply(Modifiers.makeHorizontalSlope(quadFace == this.facing.getCounterClockWise(), 45.0f)).export(quadMap.get(null));
        } else if (!(this.ySlope || yOrient || yFacing || quadFace != this.facing)) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.getOpposite(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(false, 45.0f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.getOpposite(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(true, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && !yOrient && !yFacing && Utils.isY(quadFace)) {
            boolean right = this.orientation == this.facing.getClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing, 0.5f)).apply(Modifiers.cutTopBottom(orientOpp, right ? 0.0f : 1.0f, right ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
        }
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return TranslatedItemModelInfo.HAND_Y_HALF_UP;
    }
}

