/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopeslab;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedSlopeSlabGeometry
extends Geometry {
    public static final float SLOPE_ANGLE = (float)(90.0 - Math.toDegrees(Math.atan(0.5)));
    public static final float SLOPE_ANGLE_VERT = (float)Math.toDegrees(Math.atan(0.5));
    private final Direction facing;
    private final boolean top;
    private final boolean topHalf;
    private final boolean ySlope;

    public FramedSlopeSlabGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
        this.topHalf = (Boolean)ctx.state().getValue((Property)PropertyHolder.TOP_HALF);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        boolean offset;
        Direction face = quad.getDirection();
        boolean bl = offset = this.top != this.topHalf;
        if (!this.ySlope && face == this.facing.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.makeVerticalSlope(!this.top, SLOPE_ANGLE)).applyIf(Modifiers.offset(this.top ? Direction.DOWN : Direction.UP, 0.5f), offset).export(quadMap.get(null));
        } else if (this.ySlope && (!this.top && face == Direction.UP || this.top && face == Direction.DOWN)) {
            QuadModifier.of(quad).apply(Modifiers.makeVerticalSlope(this.facing.getOpposite(), SLOPE_ANGLE_VERT)).applyIf(Modifiers.offset(this.top ? Direction.UP : Direction.DOWN, 0.5f), !offset).export(quadMap.get(null));
        } else if (face == this.facing) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.topHalf, 0.5f)).export(quadMap.get(face));
        } else if (face == this.facing.getClockWise() || face == this.facing.getCounterClockWise()) {
            float right;
            boolean rightFace;
            boolean bl2 = rightFace = face == this.facing.getClockWise();
            float f = rightFace ? (offset ? 0.5f : 0.0f) : (right = offset ? 1.0f : 0.5f);
            float left = rightFace ? (offset ? 1.0f : 0.5f) : (offset ? 0.5f : 0.0f);
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, right, left)).applyIf(Modifiers.cutSideUpDown(!this.top, 0.5f), offset).export(quadMap.get(face));
        } else if (this.top && !this.topHalf && face == Direction.UP || !this.top && this.topHalf && face == Direction.DOWN) {
            QuadModifier.of(quad).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return TranslatedItemModelInfo.HAND_Y_HALF_UP;
    }
}

