/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ReloadableShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeGenerator;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedWallBlock
extends WallBlock
implements IFramedBlock {
    private static final Map<Direction, EnumProperty<WallSide>> PROPERTY_BY_DIRECTION = Map.of(Direction.NORTH, NORTH_WALL, Direction.EAST, EAST_WALL, Direction.SOUTH, SOUTH_WALL, Direction.WEST, WEST_WALL);
    private final ShapeProvider shapes = this.makeShapeProvider(states -> FramedWallBlock.generateShapes((ImmutableList<BlockState>)states, 14.0f, 16.0f));
    private final ShapeProvider collisionShapes = this.makeShapeProvider(states -> FramedWallBlock.generateShapes((ImmutableList<BlockState>)states, 24.0f, 24.0f));

    public FramedWallBlock() {
        super(IFramedBlock.createProperties(BlockType.FRAMED_WALL));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.STATE_LOCKED, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.STATE_LOCKED, FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = this.updateShapeLockable(state, level, currentPos, () -> super.updateShape(state, facing, facingState, level, currentPos, facingPos));
        if (newState == state) {
            this.updateCulling((LevelReader)level, currentPos);
        }
        return newState;
    }

    public boolean connectsTo(BlockState adjState, boolean sideSolid, Direction adjSide) {
        EnumProperty<WallSide> prop;
        if (!Utils.isY(adjSide) && adjState.getBlock() == this && ((Boolean)adjState.getValue((Property)FramedProperties.STATE_LOCKED)).booleanValue() && adjState.getValue(prop = PROPERTY_BY_DIRECTION.get(adjSide)) == WallSide.NONE) {
            return false;
        }
        return super.connectsTo(adjState, sideSolid, adjSide);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.updateCulling((LevelReader)level, pos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.shapes.get(state);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.collisionShapes.get(state);
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.getShadeBrightness(state, level, pos));
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.getDrops(state, builder), builder);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> lines, TooltipFlag flag) {
        this.appendCamoHoverText(stack, lines);
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.FRAMED_WALL;
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)EAST_WALL, (Comparable)WallSide.LOW)).setValue((Property)WEST_WALL, (Comparable)WallSide.LOW);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)EAST_WALL, (Comparable)WallSide.LOW)).setValue((Property)WEST_WALL, (Comparable)WallSide.LOW);
    }

    protected Map<BlockState, VoxelShape> makeShapes(float pWidth, float pDepth, float pWallPostHeight, float pWallMinY, float pWallLowHeight, float pWallTallHeight) {
        return Map.of();
    }

    private ShapeProvider makeShapeProvider(ShapeGenerator generator) {
        ImmutableList states = this.stateDefinition.getPossibleStates();
        if (!FMLEnvironment.production) {
            return new ReloadableShapeProvider(generator, (ImmutableList<BlockState>)states);
        }
        return generator.generate((ImmutableList<BlockState>)states);
    }

    private static ShapeProvider generateShapes(ImmutableList<BlockState> states, float lowHeight, float tallHeight) {
        boolean sameHeight = lowHeight == tallHeight;
        VoxelShape centerLowShape = FramedWallBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)lowHeight, (double)11.0);
        VoxelShape centerTallShape = sameHeight ? centerLowShape : FramedWallBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)tallHeight, (double)11.0);
        VoxelShape postShape = FramedWallBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)tallHeight, (double)12.0);
        VoxelShape wallLowShape = FramedWallBlock.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)lowHeight, (double)5.0);
        VoxelShape wallTallShape = sameHeight ? wallLowShape : FramedWallBlock.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)tallHeight, (double)5.0);
        VoxelShape[] wallLowShapes = ShapeUtils.makeHorizontalRotations(wallLowShape, Direction.NORTH);
        VoxelShape[] wallTallShapes = sameHeight ? wallLowShapes : ShapeUtils.makeHorizontalRotations(wallTallShape, Direction.NORTH);
        VoxelShape[] shapes = new VoxelShape[512];
        for (WallSide north : NORTH_WALL.getPossibleValues()) {
            for (WallSide east : EAST_WALL.getPossibleValues()) {
                for (WallSide south : SOUTH_WALL.getPossibleValues()) {
                    for (WallSide west : WEST_WALL.getPossibleValues()) {
                        int noUpKey = FramedWallBlock.makeShapeKey(false, north, east, south, west);
                        int upKey = FramedWallBlock.makeShapeKey(true, north, east, south, west);
                        boolean anyTall = north == WallSide.TALL || east == WallSide.TALL || south == WallSide.TALL || west == WallSide.TALL;
                        shapes[noUpKey] = ShapeUtils.or(anyTall ? centerTallShape : centerLowShape, FramedWallBlock.getWallShape(north, Direction.NORTH, wallLowShapes, wallTallShapes), FramedWallBlock.getWallShape(east, Direction.EAST, wallLowShapes, wallTallShapes), FramedWallBlock.getWallShape(south, Direction.SOUTH, wallLowShapes, wallTallShapes), FramedWallBlock.getWallShape(west, Direction.WEST, wallLowShapes, wallTallShapes));
                        shapes[upKey] = ShapeUtils.or(postShape, FramedWallBlock.getWallShape(north, Direction.NORTH, wallLowShapes, wallTallShapes), FramedWallBlock.getWallShape(east, Direction.EAST, wallLowShapes, wallTallShapes), FramedWallBlock.getWallShape(south, Direction.SOUTH, wallLowShapes, wallTallShapes), FramedWallBlock.getWallShape(west, Direction.WEST, wallLowShapes, wallTallShapes));
                    }
                }
            }
        }
        shapes[0] = Shapes.block();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            int key = FramedWallBlock.makeShapeKey((Boolean)state.getValue((Property)UP), (WallSide)state.getValue((Property)NORTH_WALL), (WallSide)state.getValue((Property)EAST_WALL), (WallSide)state.getValue((Property)SOUTH_WALL), (WallSide)state.getValue((Property)WEST_WALL));
            builder.put((Object)state, (Object)shapes[key]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static VoxelShape getWallShape(WallSide side, Direction dir, VoxelShape[] lowShapes, VoxelShape[] tallShapes) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case WallSide.NONE -> Shapes.empty();
            case WallSide.LOW -> lowShapes[dir.get2DDataValue()];
            case WallSide.TALL -> tallShapes[dir.get2DDataValue()];
        };
    }

    private static int makeShapeKey(boolean up, WallSide north, WallSide east, WallSide south, WallSide west) {
        return (up ? 1 : 0) << 8 | north.ordinal() << 6 | east.ordinal() << 4 | south.ordinal() << 2 | west.ordinal();
    }
}

