/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.conpreds.slopeedge;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.contex.ConnectionPredicate;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;

public final class CornerSlopeEdgeConnectionPredicate
implements ConnectionPredicate {
    @Override
    public boolean canConnectFullEdge(BlockState state, Direction side, @Nullable Direction edge) {
        return false;
    }

    @Override
    public boolean canConnectDetailed(BlockState state, Direction side, Direction edge) {
        Direction backTwo;
        Direction backOne;
        Direction bottom;
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
        boolean alt = (Boolean)state.getValue((Property)PropertyHolder.ALT_TYPE);
        if (type.isHorizontal()) {
            bottom = dir;
            backOne = type.isTop() ? Direction.UP : Direction.DOWN;
            backTwo = type.isRight() ? dir.getClockWise() : dir.getCounterClockWise();
        } else {
            bottom = type.isTop() ? Direction.UP : Direction.DOWN;
            backOne = dir;
            backTwo = dir.getCounterClockWise();
        }
        if (side == bottom) {
            return edge == backOne || edge == backTwo;
        }
        if (side == backOne) {
            return edge == backTwo || !alt && edge == bottom;
        }
        if (side == backTwo) {
            return edge == backOne || !alt && edge == bottom;
        }
        if (side == backOne.getOpposite()) {
            return edge == backTwo || !alt && edge == bottom;
        }
        if (side == backTwo.getOpposite()) {
            return edge == backOne || !alt && edge == bottom;
        }
        if (side == bottom.getOpposite()) {
            return edge == backOne || edge == backTwo;
        }
        return false;
    }
}

