/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.providers;

import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.render.item.BlueprintPropertyOverride;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.ae2.AppliedEnergisticsCompat;

public final class FramedItemModelProvider
extends ItemModelProvider {
    public FramedItemModelProvider(PackOutput output, ExistingFileHelper fileHelper) {
        super(output, "framedblocks", fileHelper);
    }

    protected void registerModels() {
        this.handheldItem(FBContent.ITEM_FRAMED_HAMMER, "cutout");
        this.handheldItem(FBContent.ITEM_FRAMED_WRENCH, "cutout");
        this.handheldItem(FBContent.ITEM_FRAMED_KEY, "cutout");
        this.handheldItem(FBContent.ITEM_FRAMED_SCREWDRIVER, "cutout");
        this.simpleItem(FBContent.ITEM_FRAMED_REINFORCEMENT, "cutout");
        this.simpleItem(FBContent.ITEM_PHANTOM_PASTE, "cutout");
        ResourceLocation patternTexture = Utils.rl("ae2", "item/crafting_pattern");
        if (!AppliedEnergisticsCompat.isLoaded()) {
            this.existingFileHelper.trackGenerated(patternTexture, (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE);
        }
        this.singleTexture("framing_saw_pattern", this.mcLoc("item/generated"), "layer0", patternTexture);
        ItemModelBuilder modelNormal = this.simpleItem(FBContent.ITEM_FRAMED_BLUEPRINT, "cutout");
        ItemModelBuilder modelWritten = this.simpleItem("framed_blueprint_written", "cutout");
        modelNormal.override().predicate(BlueprintPropertyOverride.HAS_DATA, 0.0f).model((ModelFile)modelNormal).end().override().predicate(BlueprintPropertyOverride.HAS_DATA, 1.0f).model((ModelFile)modelWritten).end();
    }

    private ItemModelBuilder handheldItem(Holder<Item> item, String renderType) {
        String name = Utils.getKeyOrThrow(item).location().getPath();
        return (ItemModelBuilder)((ItemModelBuilder)this.singleTexture(name, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + name))).renderType(renderType);
    }

    private ItemModelBuilder simpleItem(Holder<Item> item, String renderType) {
        return this.simpleItem(Utils.getKeyOrThrow(item).location().getPath(), renderType);
    }

    private ItemModelBuilder simpleItem(String name, String renderType) {
        return (ItemModelBuilder)((ItemModelBuilder)this.singleTexture(name, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + name))).renderType(renderType);
    }

    private ItemModelBuilder builder(Holder<Item> item) {
        return (ItemModelBuilder)this.getBuilder(Utils.getKeyOrThrow(item).location().getPath());
    }
}

