/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.DreadBeastEntity;
import com.iafenvoy.iceandfire.entity.DreadGhoulEntity;
import com.iafenvoy.iceandfire.entity.DreadHorseEntity;
import com.iafenvoy.iceandfire.entity.DreadLichEntity;
import com.iafenvoy.iceandfire.entity.DreadScuttlerEntity;
import com.iafenvoy.iceandfire.entity.DreadThrallEntity;
import com.iafenvoy.iceandfire.entity.util.IDreadMob;
import com.iafenvoy.iceandfire.entity.util.IHumanoid;
import com.iafenvoy.iceandfire.registry.IafEntities;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class DreadMobEntity
extends Monster
implements IDreadMob {
    protected static final EntityDataAccessor<Optional<UUID>> COMMANDER_UNIQUE_ID = SynchedEntityData.defineId(DreadMobEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public DreadMobEntity(EntityType<? extends Monster> t, Level worldIn) {
        super(t, worldIn);
    }

    public static Entity necromancyEntity(LivingEntity entity) {
        if (entity.getType().is(EntityTypeTags.ARTHROPOD)) {
            DreadScuttlerEntity lichSummoned = new DreadScuttlerEntity((EntityType<? extends DreadScuttlerEntity>)((EntityType)IafEntities.DREAD_SCUTTLER.get()), entity.level());
            float readInScale = entity.getBbWidth() / 1.5f;
            Level level = entity.level();
            if (level instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverWorldAccess = (ServerLevelAccessor)level;
                lichSummoned.finalizeSpawn(serverWorldAccess, entity.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            }
            lichSummoned.setSize(readInScale);
            return lichSummoned;
        }
        if (entity instanceof Zombie || entity instanceof IHumanoid) {
            DreadGhoulEntity lichSummoned = new DreadGhoulEntity((EntityType<? extends DreadGhoulEntity>)((EntityType)IafEntities.DREAD_GHOUL.get()), entity.level());
            float readInScale = entity.getBbWidth() / 0.6f;
            Level level = entity.level();
            if (level instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverWorldAccess = (ServerLevelAccessor)level;
                lichSummoned.finalizeSpawn(serverWorldAccess, entity.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            }
            lichSummoned.setSize(readInScale);
            return lichSummoned;
        }
        if (entity.getType().is(EntityTypeTags.UNDEAD) || entity instanceof AbstractSkeleton || entity instanceof Player) {
            DreadThrallEntity lichSummoned = new DreadThrallEntity((EntityType<? extends DreadThrallEntity>)((EntityType)IafEntities.DREAD_THRALL.get()), entity.level());
            Level serverWorldAccess = entity.level();
            if (serverWorldAccess instanceof ServerLevelAccessor) {
                EquipmentSlot[] serverWorldAccess2 = (EquipmentSlot[])serverWorldAccess;
                lichSummoned.finalizeSpawn((ServerLevelAccessor)serverWorldAccess2, entity.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            }
            lichSummoned.setCustomArmorHead(false);
            lichSummoned.setCustomArmorChest(false);
            lichSummoned.setCustomArmorLegs(false);
            lichSummoned.setCustomArmorFeet(false);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                lichSummoned.setItemSlot(slot, entity.getItemBySlot(slot));
            }
            return lichSummoned;
        }
        if (entity instanceof AbstractHorse) {
            return new DreadHorseEntity((EntityType<? extends DreadHorseEntity>)((EntityType)IafEntities.DREAD_HORSE.get()), entity.level());
        }
        if (entity instanceof Animal) {
            DreadBeastEntity lichSummoned = new DreadBeastEntity((EntityType<? extends DreadBeastEntity>)((EntityType)IafEntities.DREAD_BEAST.get()), entity.level());
            float readInScale = entity.getBbWidth() / 1.2f;
            Level level = entity.level();
            if (level instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverWorldAccess = (ServerLevelAccessor)level;
                lichSummoned.finalizeSpawn(serverWorldAccess, entity.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            }
            lichSummoned.setSize(readInScale);
            return lichSummoned;
        }
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COMMANDER_UNIQUE_ID, Optional.empty());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getCommanderId() != null) {
            compound.putUUID("CommanderUUID", this.getCommanderId());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        UUID uuid;
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("CommanderUUID")) {
            uuid = compound.getUUID("CommanderUUID");
        } else {
            String s = compound.getString("CommanderUUID");
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setCommanderId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isAlliedTo(Entity entityIn) {
        return entityIn instanceof IDreadMob || super.isAlliedTo(entityIn);
    }

    public UUID getCommanderId() {
        return ((Optional)this.entityData.get(COMMANDER_UNIQUE_ID)).orElse(null);
    }

    public void setCommanderId(UUID uuid) {
        this.entityData.set(COMMANDER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public void aiStep() {
        DreadLichEntity lich;
        Entity entity;
        super.aiStep();
        if (!this.level().isClientSide && (entity = this.getCommander()) instanceof DreadLichEntity && (lich = (DreadLichEntity)entity).getTarget() != null && lich.getTarget().isAlive()) {
            this.setTarget(lich.getTarget());
        }
    }

    @Override
    public Entity getCommander() {
        try {
            Entity entity;
            Player player;
            UUID uuid = this.getCommanderId();
            Player player2 = player = uuid == null ? null : this.level().getPlayerByUUID(uuid);
            if (player != null) {
                return player;
            }
            if (!this.level().isClientSide && (entity = this.level().getServer().getLevel(this.level().dimension()).getEntity(uuid)) instanceof LivingEntity) {
                return entity;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    public void onKillEntity(LivingEntity LivingEntityIn) {
        Entity summoned;
        DreadMobEntity commander;
        DreadMobEntity dreadMobEntity = commander = this instanceof DreadLichEntity ? this : this.getCommander();
        if (commander != null && !(LivingEntityIn instanceof DragonBaseEntity) && (summoned = DreadMobEntity.necromancyEntity(LivingEntityIn)) != null) {
            summoned.copyPosition((Entity)LivingEntityIn);
            if (!this.level().isClientSide) {
                this.level().addFreshEntity(summoned);
            }
            if (commander instanceof DreadLichEntity) {
                DreadLichEntity lich = (DreadLichEntity)commander;
                lich.setMinionCount(lich.getMinionCount() + 1);
            }
            if (summoned instanceof DreadMobEntity) {
                DreadMobEntity mob = (DreadMobEntity)summoned;
                mob.setCommanderId(commander.getUUID());
            }
        }
    }

    public void remove(Entity.RemovalReason reason) {
        Entity entity;
        if (!this.isRemoved() && this.getCommander() != null && (entity = this.getCommander()) instanceof DreadLichEntity) {
            DreadLichEntity lich = (DreadLichEntity)entity;
            lich.setMinionCount(lich.getMinionCount() - 1);
        }
        super.remove(reason);
    }
}

