/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.DragonChargeEntity;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonDestructionManager;
import com.iafenvoy.iceandfire.particle.DragonFrostParticleType;
import com.iafenvoy.iceandfire.registry.IafDamageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.level.Level;

public class IceDragonChargeEntity
extends DragonChargeEntity {
    public IceDragonChargeEntity(EntityType<? extends Fireball> type, Level worldIn) {
        super(type, worldIn);
    }

    public IceDragonChargeEntity(EntityType<? extends Fireball> type, Level worldIn, double posX, double posY, double posZ, double accelX, double accelY, double accelZ) {
        super(type, worldIn, posX, posY, posZ, accelX, accelY, accelZ);
    }

    public IceDragonChargeEntity(EntityType<? extends Fireball> type, Level worldIn, DragonBaseEntity shooter, double accelX, double accelY, double accelZ) {
        super(type, worldIn, shooter, accelX, accelY, accelZ);
    }

    @Override
    public void tick() {
        for (int i = 0; i < 10; ++i) {
            this.level().addParticle((ParticleOptions)new DragonFrostParticleType(3.0f), this.getX() + this.random.nextDouble() * 1.0 * (double)(this.random.nextBoolean() ? -1 : 1), this.getY() + this.random.nextDouble() * 1.0 * (double)(this.random.nextBoolean() ? -1 : 1), this.getZ() + this.random.nextDouble() * 1.0 * (double)(this.random.nextBoolean() ? -1 : 1), 0.0, 0.0, 0.0);
        }
        super.tick();
    }

    @Override
    public DamageSource causeDamage(Entity cause) {
        return IafDamageTypes.causeDragonIceDamage(cause);
    }

    @Override
    public void destroyArea(Level world, BlockPos center, DragonBaseEntity destroyer) {
        IafDragonDestructionManager.destroyAreaCharge(world, center, destroyer);
    }

    @Override
    public float getDamage() {
        return ((Double)IafCommonConfig.INSTANCE.dragon.attackDamageIce.getValue()).floatValue();
    }

    protected boolean shouldBurn() {
        return false;
    }
}

