/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.SirenEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class AquaticAIGetInWaterGoal
extends Goal {
    private final Mob creature;
    private final double movementSpeed;
    private final Level world;
    private double shelterX;
    private double shelterY;
    private double shelterZ;

    public AquaticAIGetInWaterGoal(Mob theCreatureIn, double movementSpeedIn) {
        this.creature = theCreatureIn;
        this.movementSpeed = movementSpeedIn;
        this.world = theCreatureIn.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    protected boolean isAttackerInWater() {
        return this.creature.getTarget() != null && !this.creature.getTarget().isInWater();
    }

    public boolean canUse() {
        SirenEntity siren;
        TamableAnimal tameable;
        Mob mob;
        if (this.creature.isVehicle() || (mob = this.creature) instanceof TamableAnimal && (tameable = (TamableAnimal)mob).isTame() || this.creature.isInWater() || this.isAttackerInWater() || (mob = this.creature) instanceof SirenEntity && ((siren = (SirenEntity)mob).isSinging() || siren.wantsToSing())) {
            return false;
        }
        Vec3 Vector3d = this.findPossibleShelter();
        if (Vector3d == null) {
            return false;
        }
        this.shelterX = Vector3d.x;
        this.shelterY = Vector3d.y;
        this.shelterZ = Vector3d.z;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.creature.getNavigation().isDone();
    }

    public void start() {
        this.creature.getNavigation().moveTo(this.shelterX, this.shelterY, this.shelterZ, this.movementSpeed);
    }

    public Vec3 findPossibleShelter() {
        return this.findPossibleShelter(10);
    }

    protected Vec3 findPossibleShelter(int xz) {
        RandomSource random = this.creature.getRandom();
        BlockPos blockpos = BlockPos.containing((double)this.creature.getBlockX(), (double)this.creature.getBoundingBox().minY, (double)this.creature.getBlockZ());
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.offset(random.nextInt(xz * 2) - xz, random.nextInt(6) - 3, random.nextInt(xz * 2) - xz);
            if (!this.world.getBlockState(blockpos1).is(Blocks.WATER)) continue;
            return new Vec3((double)blockpos1.getX(), (double)blockpos1.getY(), (double)blockpos1.getZ());
        }
        return null;
    }
}

