/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.CyclopsEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class CyclopsAIAttackMeleeGoal
extends MeleeAttackGoal {
    public CyclopsAIAttackMeleeGoal(CyclopsEntity creature, double speedIn, boolean useLongMemory) {
        super((PathfinderMob)creature, speedIn, useLongMemory);
    }

    protected void checkAndPerformAttack(LivingEntity entity) {
        float distance = this.mob.distanceTo((Entity)entity);
        double d0 = Math.sqrt(this.getSquaredMaxAttackDistance(entity));
        if (this.isCyclopsBlinded() && distance >= 6.0f) {
            this.stop();
            return;
        }
        if ((double)distance <= d0) {
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.mob.doHurtTarget((Entity)entity);
        }
    }

    private boolean isCyclopsBlinded() {
        CyclopsEntity cyclops;
        PathfinderMob pathfinderMob = this.mob;
        return pathfinderMob instanceof CyclopsEntity && (cyclops = (CyclopsEntity)pathfinderMob).isBlinded();
    }

    protected double getSquaredMaxAttackDistance(LivingEntity entity) {
        return this.mob.getBbWidth() * 2.0f * this.mob.getBbWidth() * 2.0f + entity.getBbWidth();
    }
}

