/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.HippogryphEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class HippogryphAIWanderGoal
extends Goal {
    private final HippogryphEntity hippo;
    private final double speed;
    private double xPosition;
    private double yPosition;
    private double zPosition;

    public HippogryphAIWanderGoal(HippogryphEntity creatureIn, double speedIn) {
        this.hippo = creatureIn;
        this.speed = speedIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.hippo.canMove()) {
            return false;
        }
        if (this.hippo.isFlying() || this.hippo.isHovering()) {
            return false;
        }
        Vec3 Vector3d = DefaultRandomPos.getPos((PathfinderMob)this.hippo, (int)10, (int)0);
        if (Vector3d == null) {
            return false;
        }
        this.xPosition = Vector3d.x;
        this.yPosition = Vector3d.y + (double)this.hippo.getRandom().nextIntBetweenInclusive(-4, 2);
        this.zPosition = Vector3d.z;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.hippo.getNavigation().isDone();
    }

    public void start() {
        this.hippo.getNavigation().moveTo(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }
}

