/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.PixieEntity;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetItemsGoal;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.iceandfire.util.IafMath;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;

public class PixieAIPickupItemGoal<T extends ItemEntity>
extends TargetGoal {
    protected final DragonAITargetItemsGoal.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super ItemEntity> targetEntitySelector;
    protected ItemEntity targetEntity;
    private List<ItemEntity> list = IafMath.emptyItemEntityList;

    public PixieAIPickupItemGoal(PixieEntity creature, boolean checkSight) {
        this(creature, checkSight, false);
    }

    public PixieAIPickupItemGoal(PixieEntity creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 20, checkSight, onlyNearby, null);
    }

    public PixieAIPickupItemGoal(PixieEntity creature, int chance, boolean checkSight, boolean onlyNearby, Predicate<? super T> targetSelector) {
        super((Mob)creature, checkSight, onlyNearby);
        this.theNearestAttackableTargetSorter = new DragonAITargetItemsGoal.Sorter((Entity)creature);
        this.targetEntitySelector = item -> item != null && !item.getItem().isEmpty() && (item.getItem().getItem() == Items.CAKE && !creature.isTame() || item.getItem().getItem() == Items.SUGAR && creature.isTame() && creature.getHealth() < creature.getMaxHealth());
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        PixieEntity pixie = (PixieEntity)this.mob;
        if (pixie.isPixieSitting()) {
            return false;
        }
        if (this.mob.level().getGameTime() % 4L == 0L) {
            this.list = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.getTargetableArea(this.getFollowDistance()), this.targetEntitySelector);
        }
        if (this.list.isEmpty()) {
            return false;
        }
        this.list.sort(this.theNearestAttackableTargetSorter);
        this.targetEntity = this.list.getFirst();
        return true;
    }

    protected AABB getTargetableArea(double targetDistance) {
        return this.mob.getBoundingBox().inflate(targetDistance, 4.0, targetDistance);
    }

    public void start() {
        this.mob.getMoveControl().setWantedPosition(this.targetEntity.getX(), this.targetEntity.getY(), this.targetEntity.getZ(), 0.25);
        LivingEntity attackTarget = this.mob.getTarget();
        if (attackTarget == null) {
            this.mob.getLookControl().setLookAt(this.targetEntity.getX(), this.targetEntity.getY(), this.targetEntity.getZ(), 180.0f, 20.0f);
        }
        super.start();
    }

    public void tick() {
        super.tick();
        if (this.targetEntity == null || !this.targetEntity.isAlive()) {
            this.stop();
        } else if (this.mob.distanceToSqr((Entity)this.targetEntity) < 1.0) {
            PixieEntity pixie = (PixieEntity)this.mob;
            if (this.targetEntity.getItem() != null && this.targetEntity.getItem().getItem() != null) {
                Entity entity;
                if (this.targetEntity.getItem().is(IafItemTags.HEAL_PIXIE)) {
                    pixie.heal(5.0f);
                } else if (this.targetEntity.getItem().is(IafItemTags.TAME_PIXIE) && !pixie.isTame() && (entity = this.targetEntity.getOwner()) instanceof Player) {
                    Player player = (Player)entity;
                    pixie.tame(player);
                    pixie.setPixieSitting(true);
                    pixie.setOnGround(true);
                }
            }
            pixie.setItemInHand(InteractionHand.MAIN_HAND, this.targetEntity.getItem());
            this.targetEntity.getItem().shrink(1);
            pixie.playSound((SoundEvent)IafSounds.PIXIE_TAUNT.get(), 1.0f, 1.0f);
            this.stop();
        }
    }

    public boolean canContinueToUse() {
        return true;
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d0 = this.theEntity.distanceToSqr(p_compare_1_);
            double d1 = this.theEntity.distanceToSqr(p_compare_2_);
            return Double.compare(d0, d1);
        }
    }
}

