/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.data.component.ChainData;
import com.iafenvoy.iceandfire.entity.ChainTieEntity;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.phys.AABB;

public class ChainItem
extends Item {
    private final boolean sticky;

    public ChainItem(boolean sticky) {
        super(new Item.Properties());
        this.sticky = sticky;
    }

    public static void attachToFence(Player player, Level worldIn, BlockPos fence) {
        double d0 = 30.0;
        int i = fence.getX();
        int j = fence.getY();
        int k = fence.getZ();
        for (LivingEntity livingEntity : worldIn.getEntitiesOfClass(LivingEntity.class, new AABB((double)i - d0, (double)j - d0, (double)k - d0, (double)i + d0, (double)j + d0, (double)k + d0))) {
            ChainData chainData = ChainData.get(livingEntity);
            if (!chainData.isChainedTo(player.getUUID())) continue;
            ChainTieEntity entityleashknot = ChainTieEntity.getKnotForPosition(worldIn, fence);
            if (entityleashknot == null) {
                entityleashknot = ChainTieEntity.createTie(worldIn, fence);
            }
            chainData.removeChain(player.getUUID());
            chainData.attachChain(entityleashknot.getUUID());
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.chain.desc_0").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.chain.desc_1").withStyle(ChatFormatting.GRAY));
        if (this.sticky) {
            tooltip.add((Component)Component.translatable((String)"item.iceandfire.chain_sticky.desc_2").withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.translatable((String)"item.iceandfire.chain_sticky.desc_3").withStyle(ChatFormatting.GREEN));
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        ChainData targetData = ChainData.get(target);
        if (targetData.isChainedTo(playerIn.getUUID())) {
            return InteractionResult.PASS;
        }
        if (this.sticky) {
            double d0 = 60.0;
            double i = playerIn.getX();
            double j = playerIn.getY();
            double k = playerIn.getZ();
            List nearbyEntities = playerIn.level().getEntitiesOfClass(LivingEntity.class, new AABB(i - d0, j - d0, k - d0, i + d0, j + d0, k + d0), livingEntity -> true);
            if (playerIn.isShiftKeyDown()) {
                targetData.clearChains();
                for (LivingEntity livingEntity2 : nearbyEntities) {
                    ChainData.get(livingEntity2).removeChain(target.getUUID());
                }
                return InteractionResult.SUCCESS;
            }
            AtomicBoolean flag = new AtomicBoolean(false);
            for (LivingEntity livingEntity3 : nearbyEntities) {
                ChainData nearbyData = ChainData.get(livingEntity3);
                if (!nearbyData.isChainedTo(playerIn.getUUID())) continue;
                targetData.removeChain(playerIn.getUUID());
                nearbyData.removeChain(playerIn.getUUID());
                nearbyData.attachChain(target.getUUID());
                flag.set(true);
            }
            if (!flag.get()) {
                targetData.attachChain(playerIn.getUUID());
            }
        } else {
            targetData.attachChain(playerIn.getUUID());
        }
        if (!playerIn.isCreative()) {
            stack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useOn(UseOnContext context) {
        Block block = context.getLevel().getBlockState(context.getClickedPos()).getBlock();
        if (!(block instanceof WallBlock)) {
            return InteractionResult.PASS;
        }
        if (!context.getLevel().isClientSide) {
            ChainItem.attachToFence(context.getPlayer(), context.getLevel(), context.getClickedPos());
        }
        return InteractionResult.SUCCESS;
    }
}

