/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.entity.StoneStatueEntity;
import com.iafenvoy.iceandfire.entity.util.BlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafDamageTypes;
import com.iafenvoy.iceandfire.registry.IafDataComponents;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafEntityTags;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GorgonHeadItem
extends Item {
    public GorgonHeadItem() {
        super(new Item.Properties().durability(1).component((DataComponentType)IafDataComponents.BOOL.get(), (Object)false));
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entity, int timeLeft) {
        double dist = 32.0;
        Vec3 Vector3d = entity.getEyePosition(1.0f);
        Vec3 Vector3d1 = entity.getViewVector(1.0f);
        Vec3 Vector3d2 = Vector3d.add(Vector3d1.x * dist, Vector3d1.y * dist, Vector3d1.z * dist);
        Entity pointedEntity = null;
        List list = worldIn.getEntities((Entity)entity, entity.getBoundingBox().expandTowards(Vector3d1.x * dist, Vector3d1.y * dist, Vector3d1.z * dist).inflate(1.0, 1.0, 1.0), (Predicate)((com.google.common.base.Predicate)entity12 -> {
            if (entity12 instanceof LivingEntity) {
                BlacklistedFromStatues blacklisted;
                LivingEntity livingEntity = (LivingEntity)entity12;
                boolean isImmune = livingEntity instanceof BlacklistedFromStatues && !(blacklisted = (BlacklistedFromStatues)livingEntity).canBeTurnedToStone() || entity12.getType().is(IafEntityTags.IMMUNE_TO_GORGON_STONE) || livingEntity.hasEffect(MobEffects.BLINDNESS);
                return !isImmune && entity12.isPickable() && !livingEntity.isDeadOrDying() && (entity12 instanceof Player || DragonUtils.isAlive(livingEntity));
            }
            return false;
        }));
        double d2 = dist;
        for (Entity entity1 : list) {
            double d3;
            AABB axisalignedbb = entity1.getBoundingBox().inflate((double)entity1.getPickRadius());
            Optional optional = axisalignedbb.clip(Vector3d, Vector3d2);
            if (axisalignedbb.contains(Vector3d)) {
                if (!(d2 >= 0.0)) continue;
                d2 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d3 = Vector3d.distanceTo((Vec3)optional.get())) < d2) && d2 != 0.0) continue;
            if (entity1.getRootVehicle() == entity.getRootVehicle()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                continue;
            }
            pointedEntity = entity1;
            d2 = d3;
        }
        if (pointedEntity != null && pointedEntity instanceof LivingEntity) {
            Player player;
            LivingEntity livingEntity = (LivingEntity)pointedEntity;
            boolean wasSuccesful = true;
            if (pointedEntity instanceof Player) {
                wasSuccesful = pointedEntity.hurt((DamageSource)IafDamageTypes.causeGorgonDamage(pointedEntity), 2.1474836E9f);
            } else if (!worldIn.isClientSide) {
                pointedEntity.remove(Entity.RemovalReason.KILLED);
            }
            if (wasSuccesful) {
                pointedEntity.playSound((SoundEvent)IafSounds.TURN_STONE.get(), 1.0f, 1.0f);
                StoneStatueEntity statue = StoneStatueEntity.buildStatueEntity(livingEntity);
                statue.absMoveTo(pointedEntity.getX(), pointedEntity.getY(), pointedEntity.getZ(), pointedEntity.getYRot(), pointedEntity.getXRot());
                statue.yBodyRot = pointedEntity.getYRot();
                if (!worldIn.isClientSide) {
                    worldIn.addFreshEntity((Entity)statue);
                }
            }
            if (entity instanceof Player && !(player = (Player)entity).isCreative()) {
                stack.shrink(1);
            }
        }
        stack.set((DataComponentType)IafDataComponents.BOOL.get(), (Object)false);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack itemStackIn = playerIn.getItemInHand(hand);
        playerIn.startUsingItem(hand);
        itemStackIn.set((DataComponentType)IafDataComponents.BOOL.get(), (Object)true);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int count) {
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.legendary_weapon.desc").withStyle(ChatFormatting.GRAY));
    }
}

