/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.armor;

import com.iafenvoy.iceandfire.registry.IafArmorMaterials;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class EarPlugsArmorItem
extends ArmorItem {
    public EarPlugsArmorItem() {
        super(IafArmorMaterials.EARPLUGS, ArmorItem.Type.HELMET, new Item.Properties().durability(55));
    }

    private static boolean isAprilFool() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        return calendar.get(2) + 1 == 4 && calendar.get(5) == 1;
    }

    public String getDescriptionId(ItemStack stack) {
        return EarPlugsArmorItem.isAprilFool() ? "item.%s.air_pods".formatted("iceandfire") : super.getDescriptionId(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (EarPlugsArmorItem.isAprilFool()) {
            tooltip.add((Component)Component.translatable((String)"item.iceandfire.air_pods.desc").withStyle(ChatFormatting.GREEN));
        }
    }
}

