/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.registry.IafBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class CharedPathBlock
extends DirtPathBlock {
    public static final BooleanProperty REVERTS = BooleanProperty.create((String)"revert");
    public final int dragonType;

    public CharedPathBlock(int dragonType) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).sound(dragonType != 1 ? SoundType.GRAVEL : SoundType.GLASS).strength(0.6f).friction(dragonType != 1 ? 0.6f : 0.98f).randomTicks().requiresCorrectToolForDrops());
        this.dragonType = dragonType;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)REVERTS, (Comparable)Boolean.FALSE));
    }

    public static String getNameFromType(int dragonType) {
        return switch (dragonType) {
            case 0 -> "chared_dirt_path";
            case 1 -> "frozen_dirt_path";
            case 2 -> "crackled_dirt_path";
            default -> "";
        };
    }

    public BlockState getSmushedState(int dragonType) {
        return switch (dragonType) {
            case 0 -> ((Block)IafBlocks.CHARRED_DIRT.get()).defaultBlockState();
            case 1 -> ((Block)IafBlocks.FROZEN_DIRT.get()).defaultBlockState();
            case 2 -> ((Block)IafBlocks.CRACKLED_DIRT.get()).defaultBlockState();
            default -> null;
        };
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        super.tick(state, world, pos, rand);
        if (!world.isClientSide) {
            if (!world.hasChunksAt(pos.offset(-3, -3, -3), pos.offset(3, 3, 3))) {
                return;
            }
            if (((Boolean)state.getValue((Property)REVERTS)).booleanValue() && rand.nextInt(3) == 0) {
                world.setBlockAndUpdate(pos, Blocks.DIRT_PATH.defaultBlockState());
            }
        }
        if (world.getBlockState(pos.above()).isSolid()) {
            world.setBlockAndUpdate(pos, this.getSmushedState(this.dragonType));
        }
        this.updateBlockState((Level)world, pos);
    }

    private void updateBlockState(Level worldIn, BlockPos pos) {
        if (worldIn.getBlockState(pos.above()).isSolid()) {
            worldIn.setBlockAndUpdate(pos, this.getSmushedState(this.dragonType));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{REVERTS});
    }
}

