/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.item.block.entity.DragonForgeBlockEntity;
import com.iafenvoy.iceandfire.item.block.util.DragonProof;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.util.DragonTypeProvider;
import com.mojang.serialization.MapCodec;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class DragonForgeCoreBlock
extends BaseEntityBlock
implements DragonProof,
DragonTypeProvider {
    private static final Map<DragonType, Block> ACTIVATED_MAP = new HashMap<DragonType, Block>();
    private final DragonType dragonType;

    public DragonForgeCoreBlock(DragonType dragonType, boolean activated) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).dynamicShape().strength(40.0f, 500.0f).sound(SoundType.METAL).lightLevel(state -> activated ? 15 : 0));
        this.dragonType = dragonType;
        if (activated) {
            ACTIVATED_MAP.put(dragonType, (Block)this);
        }
    }

    public static String name(DragonType dragonType, boolean activated) {
        return "dragonforge_%s_core%s".formatted(dragonType.name(), activated ? "" : "_disabled");
    }

    public static void setState(DragonType dragonType, Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        worldIn.setBlock(pos, ACTIVATED_MAP.getOrDefault(dragonType, (Block)IafBlocks.DRAGONFORGE_FIRE_CORE.get()).defaultBlockState(), 3);
        if (blockEntity != null) {
            blockEntity.clearRemoved();
            worldIn.setBlockEntity(blockEntity);
        }
    }

    @Override
    public DragonType getDragonType() {
        return this.dragonType;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.isShiftKeyDown()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity instanceof DragonForgeBlockEntity) {
                    DragonForgeBlockEntity forge = (DragonForgeBlockEntity)blockEntity;
                    MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)forge);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof DragonForgeBlockEntity) {
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)((DragonForgeBlockEntity)blockEntity));
            world.updateNeighbourForOutputSignal(pos, (Block)this);
            world.removeBlockEntity(pos);
        }
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> entityType) {
        return DragonForgeCoreBlock.createTickerHelper(entityType, (BlockEntityType)((BlockEntityType)IafBlockEntities.DRAGONFORGE_CORE.get()), DragonForgeBlockEntity::tick);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DragonForgeBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return MapCodec.unit((Object)this);
    }
}

