/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class FallingReturningStateBlock
extends FallingBlock {
    public static final BooleanProperty REVERTS = BooleanProperty.create((String)"revert");
    private final BlockState returnState;

    public FallingReturningStateBlock(float hardness, float resistance, SoundType sound, MapColor color, BlockState revertState) {
        super(BlockBehaviour.Properties.of().mapColor(color).sound(sound).strength(hardness, resistance).randomTicks());
        this.returnState = revertState;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)REVERTS, (Comparable)Boolean.FALSE));
    }

    public FallingReturningStateBlock(float hardness, float resistance, SoundType sound, boolean slippery, MapColor color, BlockState revertState) {
        super(BlockBehaviour.Properties.of().mapColor(color).sound(sound).strength(hardness, resistance).randomTicks());
        this.returnState = revertState;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)REVERTS, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return FallingReturningStateBlock.simpleCodec(s -> this);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        super.tick(state, world, pos, rand);
        if (!world.isClientSide) {
            if (!world.hasChunksAt(pos.offset(-3, -3, -3), pos.offset(3, 3, 3))) {
                return;
            }
            if (((Boolean)state.getValue((Property)REVERTS)).booleanValue() && rand.nextInt(3) == 0) {
                world.setBlockAndUpdate(pos, this.returnState);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{REVERTS});
    }
}

