/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block.entity;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.item.block.DragonForgeInputBlock;
import com.iafenvoy.iceandfire.item.block.entity.DragonForgeBlockEntity;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafDragonTypes;
import com.iafenvoy.iceandfire.util.DragonTypeProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class DragonForgeInputBlockEntity
extends BlockEntity {
    private static final int LURE_DISTANCE = 50;
    private int ticksSinceDragonFire;
    private DragonForgeBlockEntity core = null;

    public DragonForgeInputBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IafBlockEntities.DRAGONFORGE_INPUT.get(), pos, state);
    }

    public static void tick(Level level, BlockPos position, BlockState state, DragonForgeInputBlockEntity forgeInput) {
        if (forgeInput.core == null) {
            forgeInput.core = forgeInput.getConnectedTileEntity(position);
        }
        if (forgeInput.ticksSinceDragonFire > 0) {
            --forgeInput.ticksSinceDragonFire;
        }
        if ((forgeInput.ticksSinceDragonFire == 0 || forgeInput.core == null) && forgeInput.isActive()) {
            BlockEntity tileentity = level.getBlockEntity(position);
            level.setBlockAndUpdate(position, forgeInput.getDeactivatedState());
            if (tileentity != null) {
                tileentity.clearRemoved();
                level.setBlockEntity(tileentity);
            }
        }
        if (forgeInput.isAssembled()) {
            forgeInput.lureDragons();
        }
    }

    public void onHitWithFlame() {
        if (this.core != null) {
            this.core.transferPower(1);
        }
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithFullMetadata(registryLookup);
    }

    protected void lureDragons() {
        Vec3 targetPosition = new Vec3((double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 0.5f), (double)((float)this.getBlockPos().getZ() + 0.5f));
        AABB searchArea = new AABB((double)this.worldPosition.getX() - 50.0, (double)this.worldPosition.getY() - 50.0, (double)this.worldPosition.getZ() - 50.0, (double)this.worldPosition.getX() + 50.0, (double)this.worldPosition.getY() + 50.0, (double)this.worldPosition.getZ() + 50.0);
        boolean dragonSelected = false;
        assert (this.level != null);
        for (DragonBaseEntity dragon : this.level.getEntitiesOfClass(DragonBaseEntity.class, searchArea)) {
            if (!dragonSelected && this.getDragonType() == dragon.dragonType && (dragon.isChained() || dragon.isTame()) && this.canSeeInput(dragon, targetPosition)) {
                dragon.burningTarget = this.worldPosition;
                dragonSelected = true;
                continue;
            }
            if (dragon.burningTarget != this.worldPosition) continue;
            dragon.burningTarget = null;
            dragon.setBreathingFire(false);
        }
    }

    public boolean isAssembled() {
        return this.core != null && this.core.assembled() && this.core.canSmelt();
    }

    private boolean canSeeInput(DragonBaseEntity dragon, Vec3 target) {
        if (target != null) {
            assert (this.level != null);
            BlockHitResult rayTrace = this.level.clip(new ClipContext(dragon.getHeadPosition(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)dragon));
            double distance = dragon.getHeadPosition().distanceTo(rayTrace.getLocation());
            return distance < (double)(10.0f + dragon.getBbWidth() * 2.0f);
        }
        return false;
    }

    private BlockState getDeactivatedState() {
        return (BlockState)DragonForgeInputBlock.getBlockByType(this.getDragonType()).defaultBlockState().setValue((Property)DragonForgeInputBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    private DragonType getDragonType() {
        DragonType dragonType;
        Block block = this.getBlockState().getBlock();
        if (block instanceof DragonTypeProvider) {
            DragonTypeProvider provider = (DragonTypeProvider)block;
            dragonType = provider.getDragonType();
        } else {
            dragonType = IafDragonTypes.FIRE;
        }
        return dragonType;
    }

    private boolean isActive() {
        assert (this.level != null);
        BlockState state = this.level.getBlockState(this.worldPosition);
        return state.getBlock() instanceof DragonForgeInputBlock && (Boolean)state.getValue((Property)DragonForgeInputBlock.ACTIVE) != false;
    }

    private DragonForgeBlockEntity getConnectedTileEntity(BlockPos position) {
        assert (this.level != null);
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockEntity blockEntity = this.level.getBlockEntity(position.relative(facing));
            if (!(blockEntity instanceof DragonForgeBlockEntity)) continue;
            DragonForgeBlockEntity forge = (DragonForgeBlockEntity)blockEntity;
            return forge;
        }
        return null;
    }
}

