/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.network;

import com.iafenvoy.iceandfire.config.IafClientConfig;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.event.ClientEvents;
import com.iafenvoy.iceandfire.item.block.entity.JarBlockEntity;
import com.iafenvoy.iceandfire.item.block.entity.PixieHouseBlockEntity;
import com.iafenvoy.iceandfire.item.block.entity.PodiumBlockEntity;
import com.iafenvoy.iceandfire.network.payload.DragonSetBurnBlockS2CPayload;
import com.iafenvoy.iceandfire.network.payload.LightningBoltS2CPayload;
import com.iafenvoy.iceandfire.network.payload.StartRidingMobS2CPayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieHouseS2CPayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieJarS2CPayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePodiumS2CPayload;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ClientNetworkHelper {
    private static CameraType prev = CameraType.FIRST_PERSON;

    public static void registerReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, DragonSetBurnBlockS2CPayload.ID, DragonSetBurnBlockS2CPayload.CODEC, (payload, ctx) -> {
            Entity entity;
            Player player = ctx.getPlayer();
            if (player != null && (entity = player.level().getEntity(payload.entityId())) instanceof DragonBaseEntity) {
                DragonBaseEntity dragon = (DragonBaseEntity)entity;
                dragon.setBreathingFire(payload.breathing());
                dragon.burningTarget = new BlockPos((Vec3i)payload.target());
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, LightningBoltS2CPayload.ID, LightningBoltS2CPayload.CODEC, (payload, ctx) -> ctx.queue(() -> ClientEvents.LIGHTNINGS.addAll(payload.lightnings())));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, StartRidingMobS2CPayload.ID, StartRidingMobS2CPayload.CODEC, (payload, ctx) -> {
            TamableAnimal tamable;
            Entity entity;
            Options options = Minecraft.getInstance().options;
            Player player = ctx.getPlayer();
            if (player != null && (entity = player.level().getEntity(payload.dragonId())) instanceof ISyncMount && entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).isOwnedBy((LivingEntity)player) && tamable.distanceTo((Entity)player) < 14.0f) {
                if (payload.ride()) {
                    if (payload.baby()) {
                        tamable.startRiding((Entity)player, true);
                    } else {
                        player.startRiding((Entity)tamable, true);
                        if (((Boolean)IafClientConfig.INSTANCE.dragonAuto3rdPerson.getValue()).booleanValue()) {
                            prev = options.getCameraType();
                            options.setCameraType(CameraType.THIRD_PERSON_BACK);
                        }
                    }
                } else if (payload.baby()) {
                    tamable.stopRiding();
                } else {
                    player.stopRiding();
                    if (((Boolean)IafClientConfig.INSTANCE.dragonAuto3rdPerson.getValue()).booleanValue()) {
                        options.setCameraType(prev);
                    }
                }
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, UpdatePixieHouseS2CPayload.ID, UpdatePixieHouseS2CPayload.CODEC, (payload, ctx) -> {
            Player player = ctx.getPlayer();
            if (player != null) {
                BlockEntity blockEntity = player.level().getBlockEntity(payload.blockPos());
                if (blockEntity instanceof PixieHouseBlockEntity) {
                    PixieHouseBlockEntity house = (PixieHouseBlockEntity)blockEntity;
                    house.hasPixie = payload.hasPixie();
                    house.pixieType = payload.pixieType();
                } else if (blockEntity instanceof JarBlockEntity) {
                    JarBlockEntity jar = (JarBlockEntity)blockEntity;
                    jar.hasPixie = payload.hasPixie();
                    jar.pixieType = payload.pixieType();
                }
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, UpdatePixieJarS2CPayload.ID, UpdatePixieJarS2CPayload.CODEC, (payload, ctx) -> {
            BlockEntity patt0$temp;
            Player player = ctx.getPlayer();
            if (player != null && (patt0$temp = player.level().getBlockEntity(payload.blockPos())) instanceof JarBlockEntity) {
                JarBlockEntity jar = (JarBlockEntity)patt0$temp;
                jar.hasProduced = payload.isProducing();
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, UpdatePodiumS2CPayload.ID, UpdatePodiumS2CPayload.CODEC, (payload, ctx) -> {
            BlockEntity patt0$temp;
            Player player = ctx.getPlayer();
            if (player != null && (patt0$temp = player.level().getBlockEntity(payload.blockPos())) instanceof PodiumBlockEntity) {
                PodiumBlockEntity podium = (PodiumBlockEntity)patt0$temp;
                podium.setItem(0, payload.heldStack());
            }
        });
    }
}

