/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class SirenMusicParticle
extends TextureSheetParticle {
    private float colorScale;

    protected SirenMusicParticle(ClientLevel world, double x, double y, double z, double motX, double motY, double motZ, SpriteSet spriteProvider) {
        super(world, x, y, z, motX, motY, motZ);
        this.setPos(x, y, z);
        this.colorScale = 1.0f;
        this.rCol = Math.max(0.0f, Mth.sin((float)((this.colorScale + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.gCol = Math.max(0.0f, Mth.sin((float)((this.colorScale + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.bCol = Math.max(0.0f, Mth.sin((float)((this.colorScale + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.pickSprite(spriteProvider);
    }

    public static ParticleProvider<SimpleParticleType> factory(SpriteSet spriteProvider) {
        return (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new SirenMusicParticle(world, x, y, z, 1.0, 1.0, 1.0, spriteProvider);
    }

    public void tick() {
        super.tick();
        this.colorScale += 0.015f;
        if (this.colorScale > 25.0f) {
            this.colorScale = 0.0f;
        }
        this.rCol = Math.max(0.0f, Mth.sin((float)((this.colorScale + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.gCol = Math.max(0.0f, Mth.sin((float)((this.colorScale + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.bCol = Math.max(0.0f, Mth.sin((float)((this.colorScale + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
    }

    public int getLightColor(float partialTick) {
        return super.getLightColor(partialTick);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }
}

