/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.registry;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafTrollTypes;
import com.iafenvoy.iceandfire.registry.tag.CommonItemTags;
import com.iafenvoy.uranus.util.function.MemorizeSupplier;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public final class IafArmorMaterials {
    public static final DeferredRegister<ArmorMaterial> REGISTRY = DeferredRegister.create((String)"iceandfire", (ResourceKey)Registries.ARMOR_MATERIAL);
    public static final RegistrySupplier<ArmorMaterial> COPPER = IafArmorMaterials.register("copper", new int[]{1, 3, 4, 2}, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, 0.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_INGOT})));
    public static final RegistrySupplier<ArmorMaterial> SILVER = IafArmorMaterials.register("silver", new int[]{1, 4, 5, 2}, 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, 0.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of(CommonItemTags.INGOTS_SILVER)));
    public static final RegistrySupplier<ArmorMaterial> BLINDFOLD = IafArmorMaterials.register("blindfold", new int[]{1, 1, 1, 1}, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 0.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of(CommonItemTags.STRINGS)));
    public static final RegistrySupplier<ArmorMaterial> SHEEP = IafArmorMaterials.register("sheep", new int[]{1, 3, 2, 1}, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 0.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{Blocks.WHITE_WOOL})));
    public static final RegistrySupplier<ArmorMaterial> EARPLUGS = IafArmorMaterials.register("earplugs", new int[]{1, 1, 1, 1}, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 0.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{Blocks.OAK_BUTTON})));
    public static final RegistrySupplier<ArmorMaterial> DEATHWORM_YELLOW = IafArmorMaterials.register("deathworm_yellow", new int[]{2, 5, 7, 3}, 5, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.5f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafItems.DEATH_WORM_CHITIN_YELLOW.get()})));
    public static final RegistrySupplier<ArmorMaterial> DEATHWORM_WHITE = IafArmorMaterials.register("deathworm_white", new int[]{2, 5, 7, 3}, 5, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.5f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafItems.DEATH_WORM_CHITIN_RED.get()})));
    public static final RegistrySupplier<ArmorMaterial> DEATHWORM_RED = IafArmorMaterials.register("deathworm_red", new int[]{2, 5, 7, 3}, 5, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.5f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafItems.DEATH_WORM_CHITIN_WHITE.get()})));
    public static final RegistrySupplier<ArmorMaterial> TROLL_MOUNTAIN = IafArmorMaterials.register("troll_mountain", new int[]{2, 5, 7, 3}, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafTrollTypes.MOUNTAIN.leather.get()})));
    public static final RegistrySupplier<ArmorMaterial> TROLL_FOREST = IafArmorMaterials.register("troll_forest", new int[]{2, 5, 7, 3}, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafTrollTypes.FOREST.leather.get()})));
    public static final RegistrySupplier<ArmorMaterial> TROLL_FROST = IafArmorMaterials.register("troll_frost", new int[]{2, 5, 7, 3}, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafTrollTypes.FROST.leather.get()})));
    public static final RegistrySupplier<ArmorMaterial> DRAGONSTEEL_FIRE = IafArmorMaterials.register("dragonsteel_fire", new int[]{(Integer)IafCommonConfig.INSTANCE.armors.dragonsteelBootsArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelLeggingsArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelChestplateArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelHelmetArmor.getValue()}, (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelArmorEnchantability.getValue(), (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ((Double)IafCommonConfig.INSTANCE.armors.dragonsteelArmorToughness.getValue()).floatValue(), ((Double)IafCommonConfig.INSTANCE.armors.dragonsteelArmorKnockbackResistance.getValue()).floatValue(), (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafItems.DRAGONSTEEL_FIRE_INGOT.get()})));
    public static final RegistrySupplier<ArmorMaterial> DRAGONSTEEL_ICE = IafArmorMaterials.register("dragonsteel_ice", new int[]{(Integer)IafCommonConfig.INSTANCE.armors.dragonsteelBootsArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelLeggingsArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelChestplateArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelHelmetArmor.getValue()}, (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelArmorEnchantability.getValue(), (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ((Double)IafCommonConfig.INSTANCE.armors.dragonsteelArmorToughness.getValue()).floatValue(), ((Double)IafCommonConfig.INSTANCE.armors.dragonsteelArmorKnockbackResistance.getValue()).floatValue(), (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafItems.DRAGONSTEEL_ICE_INGOT.get()})));
    public static final RegistrySupplier<ArmorMaterial> DRAGONSTEEL_LIGHTNING = IafArmorMaterials.register("dragonsteel_lightning", new int[]{(Integer)IafCommonConfig.INSTANCE.armors.dragonsteelBootsArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelLeggingsArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelChestplateArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelHelmetArmor.getValue()}, (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelArmorEnchantability.getValue(), (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ((Double)IafCommonConfig.INSTANCE.armors.dragonsteelArmorToughness.getValue()).floatValue(), ((Double)IafCommonConfig.INSTANCE.armors.dragonsteelArmorKnockbackResistance.getValue()).floatValue(), (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafItems.DRAGONSTEEL_ICE_INGOT.get()})));

    public static RegistrySupplier<ArmorMaterial> register(String name, int[] damageReduction, int enchantability, Holder<SoundEvent> sound, float toughness, Supplier<Ingredient> repairIngredients) {
        return IafArmorMaterials.register(name, damageReduction, enchantability, sound, toughness, 0.0f, repairIngredients);
    }

    public static RegistrySupplier<ArmorMaterial> register(String name, int[] damageReduction, int enchantability, Holder<SoundEvent> sound, float toughness, float knockBackResistance, Supplier<Ingredient> repairIngredients) {
        return REGISTRY.register(name, () -> IafArmorMaterials.createMaterial(name, damageReduction, enchantability, sound, toughness, knockBackResistance, repairIngredients));
    }

    public static ArmorMaterial createMaterial(String name, int[] protection, int enchantAbility, Holder<SoundEvent> equipSound, float toughness, float knockBackResistance, Supplier<Ingredient> repairIngredients) {
        return new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.HELMET, protection[3]);
            map.put(ArmorItem.Type.CHESTPLATE, protection[2]);
            map.put(ArmorItem.Type.LEGGINGS, protection[1]);
            map.put(ArmorItem.Type.BOOTS, protection[0]);
        }), enchantAbility, equipSound, repairIngredients, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)name))), toughness, knockBackResistance);
    }
}

