/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.registry;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.item.block.BurntTorchBlock;
import com.iafenvoy.iceandfire.item.block.BurntTorchWallBlock;
import com.iafenvoy.iceandfire.item.block.CharedPathBlock;
import com.iafenvoy.iceandfire.item.block.DragonBoneBlock;
import com.iafenvoy.iceandfire.item.block.DragonBoneWallBlock;
import com.iafenvoy.iceandfire.item.block.DragonForgeBrickBlock;
import com.iafenvoy.iceandfire.item.block.DragonForgeCoreBlock;
import com.iafenvoy.iceandfire.item.block.DragonForgeInputBlock;
import com.iafenvoy.iceandfire.item.block.DragonScalesBlock;
import com.iafenvoy.iceandfire.item.block.DreadBaseBlock;
import com.iafenvoy.iceandfire.item.block.DreadPortalBlock;
import com.iafenvoy.iceandfire.item.block.DreadSlabBlock;
import com.iafenvoy.iceandfire.item.block.DreadSpawnerBlock;
import com.iafenvoy.iceandfire.item.block.DreadStairsBlock;
import com.iafenvoy.iceandfire.item.block.DreadStoneFaceBlock;
import com.iafenvoy.iceandfire.item.block.DreadTorchBlock;
import com.iafenvoy.iceandfire.item.block.DreadTorchWallBlock;
import com.iafenvoy.iceandfire.item.block.DreadWoodLockBlock;
import com.iafenvoy.iceandfire.item.block.DreadWoodLogBlock;
import com.iafenvoy.iceandfire.item.block.DreadwoodSaplingBlock;
import com.iafenvoy.iceandfire.item.block.EggInIceBlock;
import com.iafenvoy.iceandfire.item.block.ElementalFlowerBlock;
import com.iafenvoy.iceandfire.item.block.FallingGenericBlock;
import com.iafenvoy.iceandfire.item.block.FallingReturningStateBlock;
import com.iafenvoy.iceandfire.item.block.GenericBlock;
import com.iafenvoy.iceandfire.item.block.GhostChestBlock;
import com.iafenvoy.iceandfire.item.block.GoldPileBlock;
import com.iafenvoy.iceandfire.item.block.GraveyardSoilBlock;
import com.iafenvoy.iceandfire.item.block.IceSpikesBlock;
import com.iafenvoy.iceandfire.item.block.JarBlock;
import com.iafenvoy.iceandfire.item.block.LecternBlock;
import com.iafenvoy.iceandfire.item.block.PixieHouseBlock;
import com.iafenvoy.iceandfire.item.block.PodiumBlock;
import com.iafenvoy.iceandfire.item.block.ReturningStateBlock;
import com.iafenvoy.iceandfire.item.block.util.WallBlock;
import com.iafenvoy.iceandfire.registry.IafDragonColors;
import com.iafenvoy.iceandfire.registry.IafDragonTypes;
import com.iafenvoy.iceandfire.registry.IafItems;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public final class IafBlocks {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((String)"iceandfire", (ResourceKey)Registries.BLOCK);
    public static final RegistrySupplier<Block> LECTERN = IafBlocks.register("lectern", LecternBlock::new);
    public static final RegistrySupplier<Block> PODIUM_OAK = IafBlocks.register("podium_oak", PodiumBlock::new);
    public static final RegistrySupplier<Block> PODIUM_BIRCH = IafBlocks.register("podium_birch", PodiumBlock::new);
    public static final RegistrySupplier<Block> PODIUM_SPRUCE = IafBlocks.register("podium_spruce", PodiumBlock::new);
    public static final RegistrySupplier<Block> PODIUM_JUNGLE = IafBlocks.register("podium_jungle", PodiumBlock::new);
    public static final RegistrySupplier<Block> PODIUM_DARK_OAK = IafBlocks.register("podium_dark_oak", PodiumBlock::new);
    public static final RegistrySupplier<Block> PODIUM_ACACIA = IafBlocks.register("podium_acacia", PodiumBlock::new);
    public static final RegistrySupplier<Block> FIRE_LILY = IafBlocks.register("fire_lily", ElementalFlowerBlock::new);
    public static final RegistrySupplier<Block> FROST_LILY = IafBlocks.register("frost_lily", ElementalFlowerBlock::new);
    public static final RegistrySupplier<Block> LIGHTNING_LILY = IafBlocks.register("lightning_lily", ElementalFlowerBlock::new);
    public static final RegistrySupplier<Block> GOLD_PILE = IafBlocks.register("gold_pile", GoldPileBlock::new);
    public static final RegistrySupplier<Block> SILVER_PILE = IafBlocks.register("silver_pile", GoldPileBlock::new);
    public static final RegistrySupplier<Block> COPPER_PILE = IafBlocks.register("copper_pile", GoldPileBlock::new);
    public static final RegistrySupplier<Block> SILVER_ORE = IafBlocks.register("silver_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)2), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(3.0f, 3.0f).requiresCorrectToolForDrops()));
    public static final RegistrySupplier<Block> DEEPSLATE_SILVER_ORE = IafBlocks.register("deepslate_silver_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)2), BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).strength(3.0f, 3.0f).requiresCorrectToolForDrops()));
    public static final RegistrySupplier<Block> SILVER_BLOCK = IafBlocks.register("silver_block", () -> GenericBlock.builder(3.0f, 5.0f, SoundType.METAL, MapColor.METAL, null, null, false));
    public static final RegistrySupplier<Block> SAPPHIRE_ORE = IafBlocks.register("sapphire_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(4.0f, 3.0f).requiresCorrectToolForDrops()));
    public static final RegistrySupplier<Block> SAPPHIRE_BLOCK = IafBlocks.register("sapphire_block", () -> GenericBlock.builder(3.0f, 6.0f, SoundType.METAL, MapColor.METAL, null, null, false));
    public static final RegistrySupplier<Block> RAW_SILVER_BLOCK = IafBlocks.register("raw_silver_block", () -> GenericBlock.builder(3.0f, 5.0f, SoundType.STONE, MapColor.METAL, NoteBlockInstrument.BASEDRUM, null, false));
    public static final RegistrySupplier<Block> CHARRED_DIRT = IafBlocks.register("chared_dirt", () -> ReturningStateBlock.builder(0.5f, 0.0f, SoundType.GRAVEL, MapColor.DIRT, null, null, false, Blocks.DIRT.defaultBlockState()));
    public static final RegistrySupplier<Block> CHARRED_GRASS = IafBlocks.register("chared_grass", () -> ReturningStateBlock.builder(0.6f, 0.0f, SoundType.GRAVEL, MapColor.GRASS, null, null, false, Blocks.GRASS_BLOCK.defaultBlockState()));
    public static final RegistrySupplier<Block> CHARRED_STONE = IafBlocks.register("chared_stone", () -> ReturningStateBlock.builder(1.5f, 10.0f, SoundType.STONE, MapColor.STONE, NoteBlockInstrument.BASEDRUM, null, false, Blocks.STONE.defaultBlockState()));
    public static final RegistrySupplier<Block> CHARRED_COBBLESTONE = IafBlocks.register("chared_cobblestone", () -> ReturningStateBlock.builder(2.0f, 10.0f, SoundType.STONE, MapColor.STONE, NoteBlockInstrument.BASEDRUM, null, false, Blocks.COBBLESTONE.defaultBlockState()));
    public static final RegistrySupplier<Block> CHARRED_GRAVEL = IafBlocks.register("chared_gravel", () -> new FallingReturningStateBlock(0.6f, 0.0f, SoundType.GRAVEL, MapColor.DIRT, Blocks.GRAVEL.defaultBlockState()));
    public static final RegistrySupplier<Block> CHARRED_DIRT_PATH = IafBlocks.register(CharedPathBlock.getNameFromType(0), () -> new CharedPathBlock(0));
    public static final RegistrySupplier<Block> ASH = IafBlocks.register("ash", () -> FallingGenericBlock.builder(0.5f, 0.0f, SoundType.SAND, MapColor.SAND, NoteBlockInstrument.SNARE));
    public static final RegistrySupplier<Block> FROZEN_DIRT = IafBlocks.register("frozen_dirt", () -> ReturningStateBlock.builder(0.5f, 0.0f, SoundType.GLASS, true, MapColor.DIRT, null, null, false, Blocks.DIRT.defaultBlockState()));
    public static final RegistrySupplier<Block> FROZEN_GRASS = IafBlocks.register("frozen_grass", () -> ReturningStateBlock.builder(0.6f, 0.0f, SoundType.GLASS, true, MapColor.GRASS, null, null, false, Blocks.GRASS_BLOCK.defaultBlockState()));
    public static final RegistrySupplier<Block> FROZEN_STONE = IafBlocks.register("frozen_stone", () -> ReturningStateBlock.builder(1.5f, 1.0f, SoundType.GLASS, true, MapColor.STONE, NoteBlockInstrument.BASEDRUM, null, false, Blocks.STONE.defaultBlockState()));
    public static final RegistrySupplier<Block> FROZEN_COBBLESTONE = IafBlocks.register("frozen_cobblestone", () -> ReturningStateBlock.builder(2.0f, 2.0f, SoundType.GLASS, true, MapColor.STONE, NoteBlockInstrument.BASEDRUM, null, false, Blocks.COBBLESTONE.defaultBlockState()));
    public static final RegistrySupplier<Block> FROZEN_GRAVEL = IafBlocks.register("frozen_gravel", () -> new FallingReturningStateBlock(0.6f, 0.0f, SoundType.GLASS, true, MapColor.DIRT, Blocks.GRAVEL.defaultBlockState()));
    public static final RegistrySupplier<Block> FROZEN_DIRT_PATH = IafBlocks.register(CharedPathBlock.getNameFromType(1), () -> new CharedPathBlock(1));
    public static final RegistrySupplier<Block> FROZEN_SPLINTERS = IafBlocks.register("frozen_splinters", () -> GenericBlock.builder(2.0f, 1.0f, SoundType.GLASS, true, MapColor.WOOD, NoteBlockInstrument.BASS, null, true));
    public static final RegistrySupplier<Block> DRAGON_ICE = IafBlocks.register("dragon_ice", () -> GenericBlock.builder(0.5f, 0.0f, SoundType.GLASS, true, MapColor.ICE, null, null, false));
    public static final RegistrySupplier<Block> DRAGON_ICE_SPIKES = IafBlocks.register("dragon_ice_spikes", IceSpikesBlock::new);
    public static final RegistrySupplier<Block> CRACKLED_DIRT = IafBlocks.register("crackled_dirt", () -> ReturningStateBlock.builder(0.5f, 0.0f, SoundType.GRAVEL, MapColor.DIRT, null, null, false, Blocks.DIRT.defaultBlockState()));
    public static final RegistrySupplier<Block> CRACKLED_GRASS = IafBlocks.register("crackled_grass", () -> ReturningStateBlock.builder(0.6f, 0.0f, SoundType.GRAVEL, MapColor.GRASS, null, null, false, Blocks.GRASS_BLOCK.defaultBlockState()));
    public static final RegistrySupplier<Block> CRACKLED_STONE = IafBlocks.register("crackled_stone", () -> ReturningStateBlock.builder(1.5f, 1.0f, SoundType.STONE, MapColor.STONE, NoteBlockInstrument.BASEDRUM, null, false, Blocks.STONE.defaultBlockState()));
    public static final RegistrySupplier<Block> CRACKLED_COBBLESTONE = IafBlocks.register("crackled_cobblestone", () -> ReturningStateBlock.builder(2.0f, 2.0f, SoundType.STONE, MapColor.STONE, NoteBlockInstrument.BASEDRUM, null, false, Blocks.COBBLESTONE.defaultBlockState()));
    public static final RegistrySupplier<Block> CRACKLED_GRAVEL = IafBlocks.register("crackled_gravel", () -> new FallingReturningStateBlock(0.6f, 0.0f, SoundType.GRAVEL, MapColor.DIRT, Blocks.GRAVEL.defaultBlockState()));
    public static final RegistrySupplier<Block> CRACKLED_DIRT_PATH = IafBlocks.register(CharedPathBlock.getNameFromType(2), () -> new CharedPathBlock(2));
    public static final RegistrySupplier<Block> NEST = IafBlocks.register("nest", () -> GenericBlock.builder(0.5f, 0.0f, SoundType.GRAVEL, false, MapColor.PLANT, null, PushReaction.DESTROY, false));
    public static final RegistrySupplier<Block> DRAGON_SCALE_RED = IafBlocks.register("dragonscale_red", () -> new DragonScalesBlock(IafDragonColors.RED));
    public static final RegistrySupplier<Block> DRAGON_SCALE_GREEN = IafBlocks.register("dragonscale_green", () -> new DragonScalesBlock(IafDragonColors.GREEN));
    public static final RegistrySupplier<Block> DRAGON_SCALE_BRONZE = IafBlocks.register("dragonscale_bronze", () -> new DragonScalesBlock(IafDragonColors.BRONZE));
    public static final RegistrySupplier<Block> DRAGON_SCALE_GRAY = IafBlocks.register("dragonscale_gray", () -> new DragonScalesBlock(IafDragonColors.GRAY));
    public static final RegistrySupplier<Block> DRAGON_SCALE_BLUE = IafBlocks.register("dragonscale_blue", () -> new DragonScalesBlock(IafDragonColors.BLUE));
    public static final RegistrySupplier<Block> DRAGON_SCALE_WHITE = IafBlocks.register("dragonscale_white", () -> new DragonScalesBlock(IafDragonColors.WHITE));
    public static final RegistrySupplier<Block> DRAGON_SCALE_SAPPHIRE = IafBlocks.register("dragonscale_sapphire", () -> new DragonScalesBlock(IafDragonColors.SAPPHIRE));
    public static final RegistrySupplier<Block> DRAGON_SCALE_SILVER = IafBlocks.register("dragonscale_silver", () -> new DragonScalesBlock(IafDragonColors.SILVER));
    public static final RegistrySupplier<Block> DRAGON_SCALE_ELECTRIC = IafBlocks.register("dragonscale_electric", () -> new DragonScalesBlock(IafDragonColors.ELECTRIC));
    public static final RegistrySupplier<Block> DRAGON_SCALE_amethyst = IafBlocks.register("dragonscale_amethyst", () -> new DragonScalesBlock(IafDragonColors.AMETHYST));
    public static final RegistrySupplier<Block> DRAGON_SCALE_COPPER = IafBlocks.register("dragonscale_copper", () -> new DragonScalesBlock(IafDragonColors.COPPER));
    public static final RegistrySupplier<Block> DRAGON_SCALE_BLACK = IafBlocks.register("dragonscale_black", () -> new DragonScalesBlock(IafDragonColors.BLACK));
    public static final RegistrySupplier<Block> DRAGON_BONE_BLOCK = IafBlocks.register("dragon_bone_block", DragonBoneBlock::new);
    public static final RegistrySupplier<Block> DRAGON_BONE_BLOCK_WALL = IafBlocks.register("dragon_bone_wall", () -> new DragonBoneWallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DRAGON_BONE_BLOCK.get()))));
    public static final RegistrySupplier<Block> DRAGONFORGE_FIRE_BRICK = IafBlocks.forgeBrick(IafDragonTypes.FIRE);
    public static final RegistrySupplier<Block> DRAGONFORGE_ICE_BRICK = IafBlocks.forgeBrick(IafDragonTypes.ICE);
    public static final RegistrySupplier<Block> DRAGONFORGE_LIGHTNING_BRICK = IafBlocks.forgeBrick(IafDragonTypes.LIGHTNING);
    public static final RegistrySupplier<Block> DRAGONFORGE_FIRE_INPUT = IafBlocks.forgeInput(IafDragonTypes.FIRE);
    public static final RegistrySupplier<Block> DRAGONFORGE_ICE_INPUT = IafBlocks.forgeInput(IafDragonTypes.ICE);
    public static final RegistrySupplier<Block> DRAGONFORGE_LIGHTNING_INPUT = IafBlocks.forgeInput(IafDragonTypes.LIGHTNING);
    public static final RegistrySupplier<Block> DRAGONFORGE_FIRE_CORE = IafBlocks.forgeCore(IafDragonTypes.FIRE, true);
    public static final RegistrySupplier<Block> DRAGONFORGE_ICE_CORE = IafBlocks.forgeCore(IafDragonTypes.ICE, true);
    public static final RegistrySupplier<Block> DRAGONFORGE_LIGHTNING_CORE = IafBlocks.forgeCore(IafDragonTypes.LIGHTNING, true);
    public static final RegistrySupplier<Block> DRAGONFORGE_FIRE_CORE_DISABLED = IafBlocks.forgeCore(IafDragonTypes.FIRE, false);
    public static final RegistrySupplier<Block> DRAGONFORGE_ICE_CORE_DISABLED = IafBlocks.forgeCore(IafDragonTypes.ICE, false);
    public static final RegistrySupplier<Block> DRAGONFORGE_LIGHTNING_CORE_DISABLED = IafBlocks.forgeCore(IafDragonTypes.LIGHTNING, false);
    public static final RegistrySupplier<Block> EGG_IN_ICE = IafBlocks.register("egginice", EggInIceBlock::new);
    public static final RegistrySupplier<Block> PIXIE_HOUSE_MUSHROOM_RED = IafBlocks.register(PixieHouseBlock.name("mushroom_red"), PixieHouseBlock::new);
    public static final RegistrySupplier<Block> PIXIE_HOUSE_MUSHROOM_BROWN = IafBlocks.register(PixieHouseBlock.name("mushroom_brown"), PixieHouseBlock::new);
    public static final RegistrySupplier<Block> PIXIE_HOUSE_OAK = IafBlocks.register(PixieHouseBlock.name("oak"), PixieHouseBlock::new);
    public static final RegistrySupplier<Block> PIXIE_HOUSE_BIRCH = IafBlocks.register(PixieHouseBlock.name("birch"), PixieHouseBlock::new);
    public static final RegistrySupplier<Block> PIXIE_HOUSE_SPRUCE = IafBlocks.register(PixieHouseBlock.name("spruce"), PixieHouseBlock::new);
    public static final RegistrySupplier<Block> PIXIE_HOUSE_DARK_OAK = IafBlocks.register(PixieHouseBlock.name("dark_oak"), PixieHouseBlock::new);
    public static final RegistrySupplier<Block> JAR_EMPTY = IafBlocks.register(JarBlock.name(-1), () -> new JarBlock(-1));
    public static final RegistrySupplier<Block> JAR_PIXIE_0 = IafBlocks.register(JarBlock.name(0), () -> new JarBlock(0));
    public static final RegistrySupplier<Block> JAR_PIXIE_1 = IafBlocks.register(JarBlock.name(1), () -> new JarBlock(1));
    public static final RegistrySupplier<Block> JAR_PIXIE_2 = IafBlocks.register(JarBlock.name(2), () -> new JarBlock(2));
    public static final RegistrySupplier<Block> JAR_PIXIE_3 = IafBlocks.register(JarBlock.name(3), () -> new JarBlock(3));
    public static final RegistrySupplier<Block> JAR_PIXIE_4 = IafBlocks.register(JarBlock.name(4), () -> new JarBlock(4));
    public static final RegistrySupplier<Block> DRAGONSTEEL_FIRE_BLOCK = IafBlocks.register("dragonsteel_fire_block", () -> GenericBlock.builder(10.0f, 1000.0f, SoundType.METAL, MapColor.METAL, null, null, false));
    public static final RegistrySupplier<Block> DRAGONSTEEL_ICE_BLOCK = IafBlocks.register("dragonsteel_ice_block", () -> GenericBlock.builder(10.0f, 1000.0f, SoundType.METAL, MapColor.METAL, null, null, false));
    public static final RegistrySupplier<Block> DRAGONSTEEL_LIGHTNING_BLOCK = IafBlocks.register("dragonsteel_lightning_block", () -> GenericBlock.builder(10.0f, 1000.0f, SoundType.METAL, MapColor.METAL, null, null, false));
    public static final RegistrySupplier<DreadBaseBlock> DREAD_STONE = IafBlocks.register("dread_stone", () -> new DreadBaseBlock(false));
    public static final RegistrySupplier<DreadBaseBlock> DREAD_STONE_BRICKS = IafBlocks.register("dread_stone_bricks", () -> new DreadBaseBlock(false));
    public static final RegistrySupplier<Block> DREAD_STONE_BRICKS_STAIRS = IafBlocks.register("dread_stone_stairs", () -> new DreadStairsBlock(((DreadBaseBlock)DREAD_STONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.of().strength(-1.0f, 3600000.0f)));
    public static final RegistrySupplier<DreadBaseBlock> DREAD_STONE_BRICKS_CHISELED = IafBlocks.register("dread_stone_bricks_chiseled", () -> new DreadBaseBlock(false));
    public static final RegistrySupplier<DreadBaseBlock> DREAD_STONE_BRICKS_CRACKED = IafBlocks.register("dread_stone_bricks_cracked", () -> new DreadBaseBlock(false));
    public static final RegistrySupplier<DreadBaseBlock> DREAD_STONE_BRICKS_MOSSY = IafBlocks.register("dread_stone_bricks_mossy", () -> new DreadBaseBlock(false));
    public static final RegistrySupplier<DreadBaseBlock> DREAD_STONE_TILE = IafBlocks.register("dread_stone_tile", () -> new DreadBaseBlock(false));
    public static final RegistrySupplier<Block> DREAD_STONE_FACE = IafBlocks.register("dread_stone_face", DreadStoneFaceBlock::new);
    public static final RegistrySupplier<DreadTorchWallBlock> DREAD_TORCH_WALL = IafBlocks.registerWallTorch("dread_torch_wall", DreadTorchWallBlock::new);
    public static final RegistrySupplier<TorchBlock> DREAD_TORCH = IafBlocks.registerWallBlock("dread_torch", DreadTorchBlock::new);
    public static final RegistrySupplier<Block> DREAD_STONE_BRICKS_SLAB = IafBlocks.register("dread_stone_slab", () -> new DreadSlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(10.0f, 10000.0f)));
    public static final RegistrySupplier<Block> DREADWOOD_LOG = IafBlocks.register("dreadwood_log", DreadWoodLogBlock::new);
    public static final RegistrySupplier<DreadBaseBlock> DREADWOOD_PLANKS = IafBlocks.register("dreadwood_planks", () -> new DreadBaseBlock(true));
    public static final RegistrySupplier<Block> DREADWOOD_LEAVES = IafBlocks.register("dreadwood_leaves", () -> Blocks.leaves((SoundType)SoundType.GRASS));
    public static final RegistrySupplier<Block> DREADWOOD_SAPLING = IafBlocks.register("dreadwood_sapling", DreadwoodSaplingBlock::new);
    public static final RegistrySupplier<Block> DREADWOOD_PLANKS_LOCK = IafBlocks.register("dreadwood_planks_lock", DreadWoodLockBlock::new);
    public static final RegistrySupplier<Block> DREAD_PORTAL = IafBlocks.register("dread_portal", DreadPortalBlock::new);
    public static final RegistrySupplier<Block> DREAD_SPAWNER = IafBlocks.register("dread_spawner", DreadSpawnerBlock::new);
    public static final RegistrySupplier<BurntTorchWallBlock> BURNT_TORCH_WALL = IafBlocks.registerWallTorch("burnt_torch_wall", BurntTorchWallBlock::new);
    public static final RegistrySupplier<TorchBlock> BURNT_TORCH = IafBlocks.registerWallBlock("burnt_torch", BurntTorchBlock::new);
    public static final RegistrySupplier<Block> GHOST_CHEST = IafBlocks.register("ghost_chest", GhostChestBlock::new);
    public static final RegistrySupplier<Block> GRAVEYARD_SOIL = IafBlocks.register("graveyard_soil", GraveyardSoilBlock::new);

    public static RegistrySupplier<Block> forgeBrick(DragonType type) {
        return IafBlocks.register(DragonForgeBrickBlock.name(type), () -> new DragonForgeBrickBlock(type));
    }

    public static RegistrySupplier<Block> forgeInput(DragonType type) {
        return IafBlocks.register(DragonForgeInputBlock.name(type), () -> new DragonForgeInputBlock(type));
    }

    public static RegistrySupplier<Block> forgeCore(DragonType type, boolean activated) {
        return IafBlocks.register(DragonForgeCoreBlock.name(type, activated), () -> new DragonForgeCoreBlock(type, activated));
    }

    public static <T extends Block> RegistrySupplier<T> register(String name, Supplier<T> block) {
        RegistrySupplier r = REGISTRY.register(name, block);
        IafItems.registerBlock(name, () -> new BlockItem((Block)r.get(), new Item.Properties()));
        return r;
    }

    private static <T extends TorchBlock> RegistrySupplier<T> registerWallBlock(String name, Supplier<T> block) {
        RegistrySupplier r = REGISTRY.register(name, block);
        IafItems.registerBlock(name, () -> new StandingAndWallBlockItem((Block)r.get(), ((WallBlock)r.get()).wallBlock(), new Item.Properties(), Direction.DOWN));
        return r;
    }

    private static <T extends WallTorchBlock> RegistrySupplier<T> registerWallTorch(String name, Supplier<T> block) {
        return REGISTRY.register(name, block);
    }
}

