/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.block;

import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.item.DragonEggItem;
import com.iafenvoy.iceandfire.item.block.entity.PodiumBlockEntity;
import com.iafenvoy.iceandfire.render.model.DragonEggModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;

public class PodiumBlockEntityRenderer<T extends PodiumBlockEntity>
implements BlockEntityRenderer<T> {
    public PodiumBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected static RenderType getEggTexture(DragonColor type) {
        return RenderType.entityCutout((ResourceLocation)type.getTextureProvider().getEggTexture());
    }

    public void render(T entity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        DragonEggModel model = new DragonEggModel();
        if (!((PodiumBlockEntity)((Object)entity)).getItem(0).isEmpty()) {
            Item item = ((PodiumBlockEntity)((Object)entity)).getItem(0).getItem();
            if (item instanceof DragonEggItem) {
                DragonEggItem item2 = (DragonEggItem)item;
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5f, 0.475f, 0.5f);
                matrixStackIn.pushPose();
                matrixStackIn.pushPose();
                model.renderPodium();
                model.renderToBuffer(matrixStackIn, bufferIn.getBuffer(PodiumBlockEntityRenderer.getEggTexture(item2.type)), combinedLightIn, combinedOverlayIn, -1);
                matrixStackIn.popPose();
                matrixStackIn.popPose();
                matrixStackIn.popPose();
            } else if (!((PodiumBlockEntity)((Object)entity)).getItem(0).isEmpty()) {
                matrixStackIn.pushPose();
                float f2 = (float)((PodiumBlockEntity)((Object)entity)).prevTicksExisted + (float)(((PodiumBlockEntity)((Object)entity)).ticksExisted - ((PodiumBlockEntity)((Object)entity)).prevTicksExisted) * partialTicks;
                float f3 = Mth.sin((float)(f2 / 10.0f)) * 0.1f + 0.1f;
                matrixStackIn.translate(0.5f, 1.55f + f3, 0.5f);
                float f4 = f2 / 20.0f;
                matrixStackIn.mulPose(Axis.YP.rotation(f4));
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.0f, 0.2f, 0.0f);
                matrixStackIn.scale(0.65f, 0.65f, 0.65f);
                Minecraft.getInstance().getItemRenderer().renderStatic(((PodiumBlockEntity)((Object)entity)).getItem(0), ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, entity.getLevel(), 0);
                matrixStackIn.popPose();
                matrixStackIn.popPose();
            }
        }
    }
}

