/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity.feature;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.DreadQueenEntity;
import com.iafenvoy.iceandfire.registry.IafDragonTypes;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;

public class DragonRiderFeatureRenderer<T extends DragonBaseEntity>
extends RenderLayer<T, TabulaModel<T>> {
    public static final List<Entity> RENDERING_RIDERS = new ArrayList<Entity>();
    private final boolean excludeDreadQueenMob;

    public DragonRiderFeatureRenderer(MobRenderer<T, TabulaModel<T>> renderIn, boolean excludeDreadQueenMob) {
        super(renderIn);
        this.excludeDreadQueenMob = excludeDreadQueenMob;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.pushPose();
        if (!dragon.getPassengers().isEmpty()) {
            float dragonScale = ((DragonBaseEntity)dragon).getRenderSize() / 3.0f;
            for (Entity passenger : dragon.getPassengers()) {
                boolean prey;
                boolean bl = prey = ((DragonBaseEntity)dragon).getControllingPassenger() == null || ((DragonBaseEntity)dragon).getControllingPassenger().getId() != passenger.getId();
                if (this.excludeDreadQueenMob && passenger instanceof DreadQueenEntity) {
                    prey = false;
                }
                float riderRot = passenger.yRotO + (passenger.getYRot() - passenger.yRotO) * partialTicks;
                int animationTicks = 0;
                if (((DragonBaseEntity)dragon).getAnimation() == DragonBaseEntity.ANIMATION_SHAKEPREY) {
                    animationTicks = ((DragonBaseEntity)dragon).getAnimationTick();
                }
                if (animationTicks == 0 || animationTicks >= 15) {
                    this.translateToBody(matrixStackIn);
                }
                if (prey) {
                    if (animationTicks == 0 || animationTicks >= 15 || ((DragonBaseEntity)dragon).isFlying()) {
                        this.translateToHead(matrixStackIn);
                        this.offsetPerDragonType(((DragonBaseEntity)dragon).dragonType, matrixStackIn);
                        EntityRenderer render = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(passenger);
                        EntityModel modelBase = null;
                        if (render instanceof MobRenderer) {
                            MobRenderer mobEntityRenderer = (MobRenderer)render;
                            modelBase = mobEntityRenderer.getModel();
                        }
                        if ((passenger.getBbHeight() > passenger.getBbWidth() || modelBase instanceof HumanoidModel) && !(modelBase instanceof QuadrupedModel) && !(modelBase instanceof HorseModel)) {
                            matrixStackIn.translate(-0.15f * passenger.getBbHeight(), 0.1f * dragonScale - 0.1f * passenger.getBbHeight(), -0.1f * dragonScale - 0.1f * passenger.getBbWidth());
                            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(90.0f));
                            matrixStackIn.mulPose(Axis.YP.rotationDegrees(45.0f));
                        } else {
                            boolean horse = modelBase instanceof HorseModel;
                            matrixStackIn.translate((horse ? -0.08f : -0.15f) * passenger.getBbWidth(), 0.1f * dragonScale - 0.15f * passenger.getBbWidth(), -0.1f * dragonScale - 0.1f * passenger.getBbWidth());
                            matrixStackIn.mulPose(Axis.XN.rotationDegrees(90.0f));
                        }
                    } else {
                        matrixStackIn.translate(0.0f, 0.555f * dragonScale, -0.5f * dragonScale);
                    }
                } else {
                    matrixStackIn.translate(0.0f, -0.01f * dragonScale, -0.035f * dragonScale);
                }
                matrixStackIn.pushPose();
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(riderRot + 180.0f));
                matrixStackIn.scale(1.0f / dragonScale, 1.0f / dragonScale, 1.0f / dragonScale);
                matrixStackIn.translate(0.0f, -0.25f, 0.0f);
                RENDERING_RIDERS.add(passenger);
                this.renderEntity(passenger, 0, 0, 0, 0.0f, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                RENDERING_RIDERS.remove(passenger);
                matrixStackIn.popPose();
            }
        }
        matrixStackIn.popPose();
    }

    protected void translateToBody(PoseStack stack) {
        this.postRender(((TabulaModel)this.getParentModel()).getCube("BodyUpper"), stack);
        this.postRender(((TabulaModel)this.getParentModel()).getCube("Neck1"), stack);
    }

    protected void translateToHead(PoseStack stack) {
        this.postRender(((TabulaModel)this.getParentModel()).getCube("Neck2"), stack);
        this.postRender(((TabulaModel)this.getParentModel()).getCube("Neck3"), stack);
        this.postRender(((TabulaModel)this.getParentModel()).getCube("Head"), stack);
    }

    protected void postRender(AdvancedModelBox renderer, PoseStack matrixStackIn) {
        if (renderer.rotateAngleX == 0.0f && renderer.rotateAngleY == 0.0f && renderer.rotateAngleZ == 0.0f) {
            if (renderer.rotationPointX != 0.0f || renderer.rotationPointY != 0.0f || renderer.rotationPointZ != 0.0f) {
                matrixStackIn.translate(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotationPointZ * 0.0625f);
            }
        } else {
            matrixStackIn.translate(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotationPointZ * 0.0625f);
            if (renderer.rotateAngleZ != 0.0f) {
                matrixStackIn.mulPose(Axis.ZP.rotation(renderer.rotateAngleZ));
            }
            if (renderer.rotateAngleY != 0.0f) {
                matrixStackIn.mulPose(Axis.YP.rotation(renderer.rotateAngleY));
            }
            if (renderer.rotateAngleX != 0.0f) {
                matrixStackIn.mulPose(Axis.XP.rotation(renderer.rotateAngleX));
            }
        }
    }

    private void offsetPerDragonType(DragonType dragonType, PoseStack stackIn) {
        if (dragonType == IafDragonTypes.LIGHTNING) {
            stackIn.translate(0.1f, -0.2f, -0.1f);
        }
    }

    public <E extends Entity> void renderEntity(E entityIn, int x, int y, int z, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        try {
            Minecraft.getInstance().getEntityRenderDispatcher().render(entityIn, (double)x, (double)y, (double)z, yaw, partialTicks, matrixStack, bufferIn, packedLight);
        }
        catch (Throwable throwable3) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable3, (String)"Rendering entity in world");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being rendered");
            entityIn.fillCrashReportCategory(crashreportcategory);
            CrashReportCategory crashreportcategory1 = crashreport.addCategory("Renderer details");
            crashreportcategory1.setDetail("Location", (Object)new BlockPos(x, y, z));
            crashreportcategory1.setDetail("Rotation", (Object)Float.valueOf(yaw));
            crashreportcategory1.setDetail("Delta", (Object)Float.valueOf(partialTicks));
            throw new ReportedException(crashreport);
        }
    }
}

