/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.uranus.ServerHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;

public interface DangerousGeneration {
    default public boolean isFarEnoughFromSpawn(LevelAccessor world, BlockPos pos) {
        return !this.getOrigin(world, pos).closerThan((Vec3i)pos, (double)this.getDangerousRadius());
    }

    default public boolean isFarEnoughFromSpawn(BlockPos pos) {
        return Optional.ofNullable(ServerHelper.server).map(server -> this.isFarEnoughFromSpawn((LevelAccessor)server.overworld(), pos)).orElse(true);
    }

    default public float getDangerousRadius() {
        return ((Double)IafCommonConfig.INSTANCE.worldGen.dangerousDistanceLimit.getValue()).floatValue();
    }

    default public BlockPos getOrigin(LevelAccessor world, BlockPos pos) {
        BlockPos spawn = world.getLevelData().getSpawnPos();
        return new BlockPos(spawn.getX(), pos.getY(), spawn.getZ());
    }
}

