/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.feature;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.SeaSerpentEntity;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.world.DangerousGeneration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluids;

public class SeaSerpentSpawnFeature
extends Feature<NoneFeatureConfiguration>
implements DangerousGeneration {
    public SeaSerpentSpawnFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos spawnPos;
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        BlockPos pos = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, context.origin().offset(8, 0, 8));
        BlockPos oceanPos = world.getHeightmapPos(Heightmap.Types.OCEAN_FLOOR_WG, pos.offset(8, 0, 8));
        if (this.isFarEnoughFromSpawn((LevelAccessor)world, pos) && random.nextDouble() < (Double)IafCommonConfig.INSTANCE.seaSerpent.spawnChance.getValue() && world.getFluidState(spawnPos = oceanPos.offset(random.nextInt(10) - 5, random.nextInt(30), random.nextInt(10) - 5)).getType() == Fluids.WATER) {
            SeaSerpentEntity serpent = (SeaSerpentEntity)((EntityType)IafEntities.SEA_SERPENT.get()).create((Level)world.getLevel());
            assert (serpent != null);
            serpent.onWorldSpawn(random);
            serpent.moveTo((float)spawnPos.getX() + 0.5f, (float)spawnPos.getY() + 0.5f, (float)spawnPos.getZ() + 0.5f, 0.0f, 0.0f);
            world.addFreshEntity((Entity)serpent);
        }
        return true;
    }
}

