/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.CyclopsEntity;
import com.iafenvoy.iceandfire.item.block.GoldPileBlock;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.world.DangerousGeneration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.LootTable;

public class CyclopsCaveStructure
extends Structure
implements DangerousGeneration {
    public static final MapCodec<CyclopsCaveStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CyclopsCaveStructure.settingsCodec((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, CyclopsCaveStructure::new));

    protected CyclopsCaveStructure(Structure.StructureSettings config) {
        super(config);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (context.random().nextDouble() >= (Double)IafCommonConfig.INSTANCE.worldGen.generateCyclopsCaveChance.getValue()) {
            return Optional.empty();
        }
        Rotation blockRotation = Rotation.getRandom((RandomSource)context.random());
        BlockPos blockPos = this.getLowestYIn5by5BoxOffset7Blocks(context, blockRotation);
        if (!this.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(blockPos, collector -> collector.addPiece((StructurePiece)new CyclopsCavePiece(0, new BoundingBox(blockPos.getX(), blockPos.getY(), blockPos.getZ(), blockPos.getX(), blockPos.getY(), blockPos.getZ())))));
    }

    public StructureType<?> type() {
        return (StructureType)IafStructureTypes.CYCLOPS_CAVE.get();
    }

    public static class CyclopsCavePiece
    extends StructurePiece {
        public static final ResourceKey<LootTable> CYCLOPS_CHEST = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"chest/cyclops_cave"));

        protected CyclopsCavePiece(int length, BoundingBox boundingBox) {
            super((StructurePieceType)IafStructurePieces.CYCLOPS_CAVE.get(), length, boundingBox);
        }

        public CyclopsCavePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.CYCLOPS_CAVE.get(), nbt);
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
        }

        public void postProcess(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            if (!chunkBox.isInside((Vec3i)pivot)) {
                return;
            }
            int size = 16;
            this.generateShell(world, pivot, random, size);
            int innerSize = size - 2;
            int x = innerSize + random.nextInt(2);
            int y = 10 + random.nextInt(2);
            int z = innerSize + random.nextInt(2);
            float radius = (float)(x + y + z) * 0.333f + 0.5f;
            int sheepPenCount = 0;
            for (BlockPos position : BlockPos.betweenClosedStream((BlockPos)pivot.offset(-x, -y, -z), (BlockPos)pivot.offset(x, y, z)).map(BlockPos::immutable).collect(Collectors.toSet())) {
                if (!(position.distSqr((Vec3i)pivot) <= (double)(radius * radius)) || position.getY() <= pivot.getY() || world.getBlockState(pivot).getBlock() instanceof AbstractChestBlock) continue;
                world.setBlock(position, Blocks.AIR.defaultBlockState(), 3);
            }
            for (BlockPos position : BlockPos.betweenClosedStream((BlockPos)pivot.offset(-x, -y, -z), (BlockPos)pivot.offset(x, y, z)).map(BlockPos::immutable).collect(Collectors.toSet())) {
                if (!(position.distSqr((Vec3i)pivot) <= (double)(radius * radius)) || position.getY() != pivot.getY()) continue;
                if (random.nextInt(130) == 0 && this.isTouchingAir((LevelAccessor)world, position.above())) {
                    this.generateSkeleton((LevelAccessor)world, position.above(), random, pivot, radius);
                }
                if (random.nextInt(130) == 0 && position.distSqr((Vec3i)pivot) <= (double)(radius * radius) * (double)0.8f && sheepPenCount < 2) {
                    this.generateSheepPen((ServerLevelAccessor)world, position.above(), random, pivot, radius);
                    ++sheepPenCount;
                }
                if (random.nextInt(80) == 0 && this.isTouchingAir((LevelAccessor)world, position.above())) {
                    BlockEntity blockEntity;
                    world.setBlock(position.above(), (BlockState)((Block)IafBlocks.GOLD_PILE.get()).defaultBlockState().setValue((Property)GoldPileBlock.LAYERS, (Comparable)Integer.valueOf(8)), 3);
                    world.setBlock(position.above().north(), (BlockState)((Block)IafBlocks.GOLD_PILE.get()).defaultBlockState().setValue((Property)GoldPileBlock.LAYERS, (Comparable)Integer.valueOf(1 + random.nextInt(7))), 3);
                    world.setBlock(position.above().south(), (BlockState)((Block)IafBlocks.GOLD_PILE.get()).defaultBlockState().setValue((Property)GoldPileBlock.LAYERS, (Comparable)Integer.valueOf(1 + random.nextInt(7))), 3);
                    world.setBlock(position.above().west(), (BlockState)((Block)IafBlocks.GOLD_PILE.get()).defaultBlockState().setValue((Property)GoldPileBlock.LAYERS, (Comparable)Integer.valueOf(1 + random.nextInt(7))), 3);
                    world.setBlock(position.above().east(), (BlockState)((Block)IafBlocks.GOLD_PILE.get()).defaultBlockState().setValue((Property)GoldPileBlock.LAYERS, (Comparable)Integer.valueOf(1 + random.nextInt(7))), 3);
                    world.setBlock(position.above(2), (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(random)), 2);
                    if (world.getBlockState(position.above(2)).getBlock() instanceof AbstractChestBlock && (blockEntity = world.getBlockEntity(position.above(2))) instanceof ChestBlockEntity) {
                        ChestBlockEntity chestBlockEntity = (ChestBlockEntity)blockEntity;
                        chestBlockEntity.setLootTable(CYCLOPS_CHEST, random.nextLong());
                    }
                }
                if (random.nextInt(50) != 0 || !this.isTouchingAir((LevelAccessor)world, position.above())) continue;
                int torchHeight = random.nextInt(2) + 1;
                for (int fence = 0; fence < torchHeight; ++fence) {
                    world.setBlock(position.above(1 + fence), this.getFenceState((LevelAccessor)world, position.above(1 + fence)), 3);
                }
                world.setBlock(position.above(1 + torchHeight), Blocks.TORCH.defaultBlockState(), 2);
            }
            CyclopsEntity cyclops = (CyclopsEntity)((EntityType)IafEntities.CYCLOPS.get()).create((Level)world.getLevel());
            if (cyclops != null) {
                cyclops.absMoveTo((double)pivot.getX() + 0.5, (double)pivot.getY() + 1.5, (double)pivot.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.addFreshEntity((Entity)cyclops);
            }
        }

        private void generateSheepPen(ServerLevelAccessor level, BlockPos position, RandomSource random, BlockPos origin, float radius) {
            BlockPos relativePosition;
            int side;
            int sideCount;
            int width = 5 + random.nextInt(3);
            int sheepAmount = 2 + random.nextInt(3);
            Direction direction = Direction.NORTH;
            BlockPos end = position;
            for (sideCount = 0; sideCount < 4; ++sideCount) {
                for (side = 0; side < width; ++side) {
                    relativePosition = end.relative(direction, side);
                    if (!(origin.distSqr((Vec3i)relativePosition) <= (double)(radius * radius))) continue;
                    level.setBlock(relativePosition, this.getFenceState((LevelAccessor)level, relativePosition), 3);
                    if (!level.isEmptyBlock(relativePosition.relative(direction.getClockWise())) || sheepAmount <= 0) continue;
                    BlockPos sheepPos = relativePosition.relative(direction.getClockWise());
                    Sheep sheep = new Sheep(EntityType.SHEEP, (Level)level.getLevel());
                    sheep.setPos((double)((float)sheepPos.getX() + 0.5f), (double)((float)sheepPos.getY() + 0.5f), (double)((float)sheepPos.getZ() + 0.5f));
                    sheep.setColor(random.nextInt(4) == 0 ? DyeColor.YELLOW : DyeColor.WHITE);
                    level.addFreshEntity((Entity)sheep);
                    --sheepAmount;
                }
                end = end.relative(direction, width);
                direction = direction.getClockWise();
            }
            for (sideCount = 0; sideCount < 4; ++sideCount) {
                for (side = 0; side < width; ++side) {
                    relativePosition = end.relative(direction, side);
                    if (!(origin.distSqr((Vec3i)relativePosition) <= (double)(radius * radius))) continue;
                    level.setBlock(relativePosition, this.getFenceState((LevelAccessor)level, relativePosition), 3);
                }
                end = end.relative(direction, width);
                direction = direction.getClockWise();
            }
        }

        private void generateSkeleton(LevelAccessor level, BlockPos position, RandomSource random, BlockPos origin, float radius) {
            Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            Direction.Axis oppositeAxis = direction.getAxis() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            int maxRibHeight = random.nextInt(2);
            for (int spine = 0; spine < 5 + random.nextInt(2) * 2; ++spine) {
                BlockPos segment = position.relative(direction, spine);
                if (origin.distSqr((Vec3i)segment) <= (double)(radius * radius)) {
                    level.setBlock(segment, (BlockState)Blocks.BONE_BLOCK.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()), 2);
                }
                if (spine % 2 == 0) continue;
                BlockPos rightRib = segment.relative(direction.getCounterClockWise());
                BlockPos leftRib = segment.relative(direction.getClockWise());
                if (origin.distSqr((Vec3i)rightRib) <= (double)(radius * radius)) {
                    level.setBlock(rightRib, (BlockState)Blocks.BONE_BLOCK.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)oppositeAxis), 2);
                }
                if (origin.distSqr((Vec3i)leftRib) <= (double)(radius * radius)) {
                    level.setBlock(leftRib, (BlockState)Blocks.BONE_BLOCK.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)oppositeAxis), 2);
                }
                for (int ribHeight = 1; ribHeight < maxRibHeight + 2; ++ribHeight) {
                    if (origin.distSqr((Vec3i)rightRib.above(ribHeight).relative(direction.getCounterClockWise())) <= (double)(radius * radius)) {
                        level.setBlock(rightRib.above(ribHeight).relative(direction.getCounterClockWise()), (BlockState)Blocks.BONE_BLOCK.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y), 2);
                    }
                    if (!(origin.distSqr((Vec3i)leftRib.above(ribHeight).relative(direction.getClockWise())) <= (double)(radius * radius))) continue;
                    level.setBlock(leftRib.above(ribHeight).relative(direction.getClockWise()), (BlockState)Blocks.BONE_BLOCK.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y), 2);
                }
                if (origin.distSqr((Vec3i)rightRib.above(maxRibHeight + 2)) <= (double)(radius * radius)) {
                    level.setBlock(rightRib.above(maxRibHeight + 2), (BlockState)Blocks.BONE_BLOCK.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)oppositeAxis), 2);
                }
                if (!(origin.distSqr((Vec3i)leftRib.above(maxRibHeight + 2)) <= (double)(radius * radius))) continue;
                level.setBlock(leftRib.above(maxRibHeight + 2), (BlockState)Blocks.BONE_BLOCK.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)oppositeAxis), 2);
            }
        }

        private boolean isTouchingAir(LevelAccessor level, BlockPos position) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (level.isEmptyBlock(position.relative(direction))) continue;
                return false;
            }
            return true;
        }

        private BlockState getFenceState(LevelAccessor level, BlockPos position) {
            boolean east = level.getBlockState(position.east()).getBlock() == Blocks.OAK_FENCE;
            boolean west = level.getBlockState(position.west()).getBlock() == Blocks.OAK_FENCE;
            boolean north = level.getBlockState(position.north()).getBlock() == Blocks.OAK_FENCE;
            boolean south = level.getBlockState(position.south()).getBlock() == Blocks.OAK_FENCE;
            return (BlockState)((BlockState)((BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue((Property)FenceBlock.EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)FenceBlock.WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)FenceBlock.NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)FenceBlock.SOUTH, (Comparable)Boolean.valueOf(south));
        }

        private void generateShell(WorldGenLevel world, BlockPos origin, RandomSource random, int size) {
            int x = size + random.nextInt(2);
            int y = 12 + random.nextInt(2);
            int z = size + random.nextInt(2);
            this.boundingBox = new BoundingBox(origin.getX() - x + 2, origin.getY(), origin.getZ() - z + 2, origin.getX() + x - 2, origin.getY() + y, origin.getZ() + z - 2);
            float radius = (float)(x + y + z) * 0.333f + 0.5f;
            for (BlockPos position : BlockPos.betweenClosedStream((BlockPos)origin.offset(-x, -y, -z), (BlockPos)origin.offset(x, y, z)).map(BlockPos::immutable).collect(Collectors.toSet())) {
                boolean isNotInDoorway;
                boolean doorwayX = position.getX() >= origin.getX() - 2 + random.nextInt(2) && position.getX() <= origin.getX() + 2 + random.nextInt(2);
                boolean doorwayZ = position.getZ() >= origin.getZ() - 2 + random.nextInt(2) && position.getZ() <= origin.getZ() + 2 + random.nextInt(2);
                boolean bl = isNotInDoorway = !doorwayX && !doorwayZ && position.getY() > origin.getY() || position.getY() > origin.getY() + y - (3 + random.nextInt(2));
                if (!(position.distSqr((Vec3i)origin) <= (double)(radius * radius))) continue;
                BlockState state = world.getBlockState(position);
                if (!(state.getBlock() instanceof AbstractChestBlock) && state.getDestroySpeed((BlockGetter)world, position) >= 0.0f && isNotInDoorway) {
                    world.setBlock(position, Blocks.STONE.defaultBlockState(), 3);
                }
                if (position.getY() == origin.getY()) {
                    world.setBlock(position, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 3);
                }
                if (position.getY() > origin.getY() - 1 || state.canOcclude()) continue;
                world.setBlock(position, Blocks.COBBLESTONE.defaultBlockState(), 3);
            }
        }
    }
}

