/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.util.HomePosition;
import com.iafenvoy.iceandfire.item.block.GoldPileBlock;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.iceandfire.world.DangerousGeneration;
import com.iafenvoy.uranus.util.RandomHelper;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.LootTable;

public abstract class DragonRoostStructure
extends Structure
implements DangerousGeneration {
    protected DragonRoostStructure(Structure.StructureSettings config) {
        super(config);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (context.random().nextDouble() >= this.getGenerateChance()) {
            return Optional.empty();
        }
        Rotation blockRotation = Rotation.getRandom((RandomSource)context.random());
        BlockPos blockPos = this.getLowestYIn5by5BoxOffset7Blocks(context, blockRotation);
        if (!this.isFarEnoughFromSpawn(blockPos) || blockPos.getY() <= context.heightAccessor().getMinBuildHeight() + 2) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(blockPos, collector -> collector.addPiece((StructurePiece)this.createPiece(new BoundingBox(blockPos.getX(), blockPos.getY(), blockPos.getZ(), blockPos.getX(), blockPos.getY(), blockPos.getZ()), context.random().nextBoolean()))));
    }

    protected abstract DragonRoostPiece createPiece(BoundingBox var1, boolean var2);

    protected abstract double getGenerateChance();

    protected static abstract class DragonRoostPiece
    extends StructurePiece {
        protected final Block treasureBlock;
        private final boolean isMale;

        protected DragonRoostPiece(StructurePieceType type, int length, BoundingBox boundingBox, Block treasureBlock, boolean isMale) {
            super(type, length, boundingBox);
            this.treasureBlock = treasureBlock;
            this.isMale = isMale;
        }

        public DragonRoostPiece(StructurePieceType type, CompoundTag nbt) {
            super(type, nbt);
            this.treasureBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)nbt.getString("treasureBlock")));
            this.isMale = nbt.getBoolean("isMale");
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
            nbt.putString("treasureBlock", BuiltInRegistries.BLOCK.getKey((Object)this.treasureBlock).toString());
            nbt.putBoolean("isMale", this.isMale);
        }

        public void postProcess(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            if (!chunkBox.isInside((Vec3i)pivot)) {
                return;
            }
            int radius = 12 + random.nextInt(8);
            this.spawnDragon(world, pivot, random, radius, this.isMale);
            this.generateSurface(world, pivot, random, radius);
            this.generateShell(world, pivot, random, radius);
            this.hollowOut(world, pivot, radius -= 2);
            this.generateDecoration(world, pivot, random, radius += 15, this.isMale);
        }

        protected void generateRoostPile(WorldGenLevel level, RandomSource random, BlockPos position, Block block) {
            int radius = random.nextInt(4);
            for (int i = 0; i < radius; ++i) {
                int layeredRadius = radius - i;
                double circularArea = this.getCircularArea(radius);
                BlockPos up = position.above(i);
                for (BlockPos blockpos : BlockPos.betweenClosedStream((BlockPos)up.offset(-layeredRadius, 0, -layeredRadius), (BlockPos)up.offset(layeredRadius, 0, layeredRadius)).map(BlockPos::immutable).collect(Collectors.toSet())) {
                    if (!(blockpos.distSqr((Vec3i)position) <= circularArea)) continue;
                    level.setBlock(blockpos, block.defaultBlockState(), 2);
                }
            }
        }

        protected double getCircularArea(int radius, int height) {
            double area = (float)(radius + height + radius) * 0.333f + 0.5f;
            return Mth.floor((double)(area * area));
        }

        protected double getCircularArea(int radius) {
            double area = (float)(radius + radius) * 0.333f + 0.5f;
            return Mth.floor((double)(area * area));
        }

        protected BlockPos getSurfacePosition(WorldGenLevel level, BlockPos position) {
            return level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, position);
        }

        protected BlockState transform(Block block) {
            return this.transform(block.defaultBlockState());
        }

        private void generateDecoration(WorldGenLevel world, BlockPos origin, RandomSource random, int radius, boolean isMale) {
            int height = radius / 5;
            double circularArea = this.getCircularArea(radius, height);
            BlockPos.betweenClosedStream((BlockPos)origin.offset(-radius, -height, -radius), (BlockPos)origin.offset(radius, height, radius)).map(BlockPos::immutable).forEach(position -> {
                if (position.distSqr((Vec3i)origin) <= circularArea) {
                    BlockEntity blockEntity;
                    BlockPos surfacePosition;
                    boolean wasPlaced;
                    BlockState transformed;
                    BlockState state;
                    double distance = position.distSqr((Vec3i)origin) / circularArea;
                    if (!world.isEmptyBlock(origin) && random.nextDouble() > distance * 0.5 && !((state = world.getBlockState(position)).getBlock() instanceof BaseEntityBlock) && state.getDestroySpeed((BlockGetter)world, position) >= 0.0f && (transformed = this.transform(state)) != state) {
                        world.setBlock(position, transformed, 2);
                    }
                    this.handleCustomGeneration(world, origin, random, (BlockPos)position, distance);
                    if (distance > 0.5 && random.nextInt(1000) == 0) {
                        this.generateBoulder((LevelAccessor)world, random, this.getSurfacePosition(world, (BlockPos)position), this.transform(Blocks.COBBLESTONE).getBlock(), random.nextInt(3), true);
                    }
                    if (distance < 0.3 && random.nextInt(isMale ? 200 : 300) == 0) {
                        this.generateTreasurePile(world, random, (BlockPos)position);
                    }
                    if (distance < 0.3 && random.nextInt(isMale ? 500 : 700) == 0 && (wasPlaced = world.setBlock(surfacePosition = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, position), (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(random)), 2)) && (blockEntity = world.getBlockEntity(surfacePosition)) instanceof ChestBlockEntity) {
                        ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                        chest.setLootTable(this.getRoostLootTable(), random.nextLong());
                    }
                    if (random.nextInt(5000) == 0) {
                        this.generateArch((LevelAccessor)world, random, this.getSurfacePosition(world, (BlockPos)position), this.transform(Blocks.COBBLESTONE).getBlock());
                    }
                }
            });
        }

        public void generateBoulder(LevelAccessor worldIn, RandomSource rand, BlockPos position, Block block, int startRadius, boolean replaceAir) {
            while (position.getY() > 3) {
                if (worldIn.isEmptyBlock(position.below())) {
                    position = position.below();
                    continue;
                }
                BlockState b = worldIn.getBlockState(position.below());
                if (b.is(IafBlockTags.GRASSES) || b.is(Blocks.DIRT) || b.is(Blocks.STONE)) break;
                position = position.below();
            }
            if (position.getY() > 3) {
                for (int i = 0; startRadius >= 0 && i < 3; ++i) {
                    int j = startRadius + rand.nextInt(2);
                    int k = startRadius + rand.nextInt(2);
                    int l = startRadius + rand.nextInt(2);
                    float f = (float)(j + k + l) * 0.333f + 0.5f;
                    for (BlockPos blockpos : BlockPos.betweenClosedStream((BlockPos)position.offset(-j, -k, -l), (BlockPos)position.offset(j, k, l)).map(BlockPos::immutable).collect(Collectors.toSet())) {
                        if (!(blockpos.distSqr((Vec3i)position) <= (double)(f * f)) || !replaceAir && !worldIn.getBlockState(blockpos).canOcclude()) continue;
                        worldIn.setBlock(blockpos, block.defaultBlockState(), 2);
                    }
                    position = position.offset(-(startRadius + 1) + rand.nextInt(2 + startRadius * 2), -rand.nextInt(2), -(startRadius + 1) + rand.nextInt(2 + startRadius * 2));
                }
            }
        }

        private void generateArch(LevelAccessor worldIn, RandomSource random, BlockPos position, Block block) {
            int height = 3 + random.nextInt(3);
            int width = Math.min(3, height - 2);
            Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            boolean diagonal = random.nextBoolean();
            for (int i = 0; i < height; ++i) {
                worldIn.setBlock(position.above(i), block.defaultBlockState(), 2);
            }
            BlockPos offsetPos = position;
            int placedWidths = 0;
            for (int i = 0; i < width; ++i) {
                offsetPos = position.above(height).relative(direction, i);
                if (diagonal) {
                    offsetPos = position.above(height).relative(direction, i).relative(direction.getClockWise(), i);
                }
                if (placedWidths < width - 1 || random.nextBoolean()) {
                    worldIn.setBlock(offsetPos, block.defaultBlockState(), 2);
                }
                ++placedWidths;
            }
            while (worldIn.isEmptyBlock(offsetPos.below()) && offsetPos.getY() > 0) {
                worldIn.setBlock(offsetPos.below(), block.defaultBlockState(), 2);
                offsetPos = offsetPos.below();
            }
        }

        private void hollowOut(WorldGenLevel world, BlockPos origin, int radius) {
            int height = 2;
            double circularArea = this.getCircularArea(radius, height);
            BlockPos up = origin.above(height - 1);
            BlockPos.betweenClosedStream((BlockPos)up.offset(-radius, 0, -radius), (BlockPos)up.offset(radius, height, radius)).map(BlockPos::immutable).forEach(position -> {
                if (position.distSqr((Vec3i)origin) <= circularArea) {
                    world.setBlock(position, Blocks.AIR.defaultBlockState(), 2);
                }
            });
        }

        private void generateShell(WorldGenLevel world, BlockPos origin, RandomSource random, int radius) {
            int height = radius / 5;
            double circularArea = this.getCircularArea(radius, height);
            int real_radius = (int)Math.sqrt(circularArea);
            this.boundingBox = new BoundingBox(origin.getX() - real_radius, origin.getY(), origin.getZ() - real_radius, origin.getX() + real_radius, origin.getY() + 3, origin.getZ() + real_radius);
            BlockPos.betweenClosedStream((BlockPos)origin.offset(-radius, -height, -radius), (BlockPos)origin.offset(radius, 1, radius)).map(BlockPos::immutable).forEach(position -> {
                if (position.distSqr((Vec3i)origin) < circularArea) {
                    world.setBlock(position, random.nextBoolean() ? this.transform(Blocks.GRAVEL) : this.transform(Blocks.DIRT), 2);
                } else if (position.distSqr((Vec3i)origin) == circularArea) {
                    world.setBlock(position, this.transform(Blocks.COBBLESTONE), 2);
                }
            });
        }

        private void generateSurface(WorldGenLevel world, BlockPos origin, RandomSource random, int radius) {
            int height = 2;
            double circularArea = this.getCircularArea(radius, height);
            BlockPos.betweenClosedStream((BlockPos)origin.offset(-radius, height, -radius), (BlockPos)origin.offset(radius, 0, radius)).map(BlockPos::immutable).forEach(position -> {
                int heightDifference = position.getY() - origin.getY();
                if (position.distSqr((Vec3i)origin) <= circularArea && heightDifference < 2 + random.nextInt(height) && !world.isEmptyBlock(position.below())) {
                    if (world.isEmptyBlock(position.above())) {
                        world.setBlock(position, this.transform(Blocks.SHORT_GRASS), 2);
                    } else {
                        world.setBlock(position, this.transform(Blocks.DIRT), 2);
                    }
                }
            });
        }

        private void generateTreasurePile(WorldGenLevel world, RandomSource random, BlockPos origin) {
            int layers = random.nextInt(3);
            for (int i = 0; i < layers; ++i) {
                int radius = layers - i;
                double circularArea = this.getCircularArea(radius);
                for (BlockPos position : BlockPos.betweenClosedStream((BlockPos)origin.offset(-radius, i, -radius), (BlockPos)origin.offset(radius, i, radius)).map(BlockPos::immutable).collect(Collectors.toSet())) {
                    if (!(position.distSqr((Vec3i)origin) <= circularArea)) continue;
                    position = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, position);
                    if (!(this.treasureBlock instanceof GoldPileBlock)) continue;
                    BlockState state = world.getBlockState(position);
                    boolean placed = false;
                    if (state.isAir()) {
                        world.setBlock(position, (BlockState)this.treasureBlock.defaultBlockState().setValue((Property)GoldPileBlock.LAYERS, (Comparable)Integer.valueOf(1 + random.nextInt(7))), 2);
                        placed = true;
                    } else if (state.getBlock() instanceof SnowLayerBlock) {
                        world.setBlock(position.below(), (BlockState)this.treasureBlock.defaultBlockState().setValue((Property)GoldPileBlock.LAYERS, (Comparable)((Integer)state.getValue((Property)SnowLayerBlock.LAYERS))), 2);
                        placed = true;
                    }
                    if (!placed || !(world.getBlockState(position.below()).getBlock() instanceof GoldPileBlock)) continue;
                    world.setBlock(position.below(), (BlockState)this.treasureBlock.defaultBlockState().setValue((Property)GoldPileBlock.LAYERS, (Comparable)Integer.valueOf(8)), 2);
                }
            }
        }

        private void spawnDragon(WorldGenLevel world, BlockPos origin, RandomSource random, int ageOffset, boolean isMale) {
            DragonBaseEntity dragon = (DragonBaseEntity)this.getDragonType().create((Level)world.getLevel());
            assert (dragon != null);
            dragon.setGender(isMale);
            dragon.growDragon(40 + ageOffset);
            dragon.setAgingDisabled(true);
            dragon.setHealth(dragon.getMaxHealth());
            dragon.setVariant(((DragonColor)RandomHelper.randomOne(dragon.dragonType.colors())).getName());
            dragon.absMoveTo((double)origin.getX() + 0.5, (double)world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, origin).getY() + 1.5, (double)origin.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
            dragon.homePos = new HomePosition(origin, (Level)world.getLevel());
            dragon.hasHomePosition = true;
            dragon.setHunger(50);
            world.addFreshEntity((Entity)dragon);
        }

        protected abstract EntityType<? extends DragonBaseEntity> getDragonType();

        protected abstract ResourceKey<LootTable> getRoostLootTable();

        protected abstract BlockState transform(BlockState var1);

        protected abstract void handleCustomGeneration(WorldGenLevel var1, BlockPos var2, RandomSource var3, BlockPos var4, double var5);
    }
}

