/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.mixin;

import fuzs.illagerinvasion.init.ModEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.structures.WoodlandMansionPieces;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WoodlandMansionPieces.WoodlandMansionPiece.class})
abstract class WoodlandMansionPieceMixin {
    WoodlandMansionPieceMixin() {
    }

    @Inject(method={"handleDataMarker"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleDataMarker(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box, CallbackInfo callback) {
        EntityType entityType;
        switch (name) {
            case "Provoker": {
                EntityType entityType2 = (EntityType)ModEntityTypes.PROVOKER_ENTITY_TYPE.value();
                break;
            }
            case "Warrior": {
                EntityType entityType2;
                if (random.nextInt(2) == 0) {
                    entityType2 = (EntityType)ModEntityTypes.BASHER_ENTITY_TYPE.value();
                    break;
                }
                entityType2 = null;
                break;
            }
            case "Archivist": {
                EntityType entityType2 = (EntityType)ModEntityTypes.ARCHIVIST_ENTITY_TYPE.value();
                break;
            }
            case "invoker": {
                EntityType entityType2 = (EntityType)ModEntityTypes.INVOKER_ENTITY_TYPE.value();
                break;
            }
            default: {
                EntityType entityType2 = entityType = null;
            }
        }
        if (entityType != null) {
            Mob mob = (Mob)entityType.create((Level)level.getLevel());
            mob.setPersistenceRequired();
            mob.moveTo(pos, 0.0f, 0.0f);
            mob.finalizeSpawn(level, level.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.STRUCTURE, null);
            level.addFreshEntityWithPassengers((Entity)mob);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
            callback.cancel();
        }
    }
}

