/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class PotionBowAttackGoal<T extends Monster>
extends Goal {
    private final Mob mob;
    private final RangedAttackMob owner;
    private final double mobSpeed;
    private final int minIntervalTicks;
    private final int maxIntervalTicks;
    private final float maxShootRange;
    private final float squaredMaxShootRange;
    private final T actor;
    private final double speed;
    private final float squaredRange;
    @Nullable
    private LivingEntity target;
    private int updateCountdownTicks = -1;
    private int seenTargetTicks;
    private int attackInterval;
    private int cooldown = -1;
    private int targetSeeingTicker;
    private boolean movingToLeft;
    private boolean backward;
    private int combatTicks = -1;

    public PotionBowAttackGoal(T actor, double speed, int attackInterval, float range) {
        this.actor = actor;
        this.speed = speed;
        this.attackInterval = attackInterval;
        this.squaredRange = range * range;
        this.owner = (RangedAttackMob)actor;
        this.mob = actor;
        this.mobSpeed = speed;
        this.minIntervalTicks = attackInterval;
        this.maxIntervalTicks = attackInterval;
        this.maxShootRange = range;
        this.squaredMaxShootRange = this.maxShootRange * this.maxShootRange;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setAttackInterval(int attackInterval) {
        this.attackInterval = attackInterval;
    }

    public boolean canUse() {
        return this.actor.getTarget() != null && this.isHoldingBow();
    }

    protected boolean isHoldingBow() {
        return this.actor.isHolding(Items.BOW) || this.actor.isHolding(Items.LINGERING_POTION);
    }

    public boolean canContinueToUse() {
        return (this.canUse() || !this.actor.getNavigation().isDone()) && this.isHoldingBow();
    }

    public void start() {
        super.start();
        this.actor.setAggressive(true);
    }

    public void stop() {
        super.stop();
        this.actor.setAggressive(false);
        this.targetSeeingTicker = 0;
        this.cooldown = -1;
        this.actor.stopUsingItem();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        boolean bl;
        double d;
        LivingEntity livingEntity = this.actor.getTarget();
        if (livingEntity == null) {
            return;
        }
        if (this.actor.getItemBySlot(EquipmentSlot.MAINHAND).is(Items.LINGERING_POTION)) {
            int updateCountdownTicks;
            d = this.mob.distanceToSqr(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
            bl = this.mob.getSensing().hasLineOfSight((Entity)livingEntity);
            int n = this.seenTargetTicks = bl ? (this.seenTargetTicks = this.seenTargetTicks + 1) : 0;
            if (d > (double)this.squaredMaxShootRange || this.seenTargetTicks < 5) {
                this.mob.getNavigation().moveTo((Entity)livingEntity, this.mobSpeed);
            } else {
                this.mob.getNavigation().stop();
            }
            this.mob.getLookControl().setLookAt((Entity)livingEntity, 30.0f, 30.0f);
            this.updateCountdownTicks = updateCountdownTicks = this.updateCountdownTicks - 1;
            if (updateCountdownTicks == 0) {
                if (!bl) {
                    return;
                }
                float f = (float)Math.sqrt(d) / this.maxShootRange;
                float g = Mth.clamp((float)f, (float)0.1f, (float)1.0f);
                this.owner.performRangedAttack(livingEntity, g);
                this.updateCountdownTicks = Mth.floor((float)(f * (float)(this.maxIntervalTicks - this.minIntervalTicks) + (float)this.minIntervalTicks));
            } else if (this.updateCountdownTicks < 0) {
                this.updateCountdownTicks = Mth.floor((double)Mth.lerp((double)(Math.sqrt(d) / (double)this.maxShootRange), (double)this.minIntervalTicks, (double)this.maxIntervalTicks));
            }
        }
        if (this.actor.getItemBySlot(EquipmentSlot.MAINHAND).is(Items.BOW)) {
            boolean bl2;
            d = this.actor.distanceToSqr(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
            bl = this.actor.getSensing().hasLineOfSight((Entity)livingEntity);
            boolean bl3 = bl2 = this.targetSeeingTicker > 0;
            if (bl != bl2) {
                this.targetSeeingTicker = 0;
            }
            this.targetSeeingTicker = bl ? ++this.targetSeeingTicker : --this.targetSeeingTicker;
            if (d > (double)this.squaredRange || this.targetSeeingTicker < 20) {
                this.actor.getNavigation().moveTo((Entity)livingEntity, this.speed);
                this.combatTicks = -1;
            } else {
                this.actor.getNavigation().stop();
                ++this.combatTicks;
            }
            if (this.combatTicks >= 20) {
                if ((double)this.actor.getRandom().nextFloat() < 0.3) {
                    this.movingToLeft = false;
                }
                if ((double)this.actor.getRandom().nextFloat() < 0.3) {
                    this.backward = !this.backward;
                }
                this.combatTicks = 0;
            }
            if (this.combatTicks > -1) {
                if (d > (double)(this.squaredRange * 0.75f)) {
                    this.backward = false;
                } else if (d < (double)(this.squaredRange * 0.25f)) {
                    this.backward = true;
                }
                this.actor.getMoveControl().strafe(this.backward ? -0.5f : 0.5f, this.movingToLeft ? 0.5f : -0.5f);
                this.actor.lookAt((Entity)livingEntity, 30.0f, 30.0f);
            } else {
                this.actor.getLookControl().setLookAt((Entity)livingEntity, 30.0f, 30.0f);
            }
            if (this.actor.isUsingItem()) {
                int i;
                if (!bl && this.targetSeeingTicker < -60) {
                    this.actor.stopUsingItem();
                } else if (bl && (i = this.actor.getTicksUsingItem()) >= 20) {
                    this.actor.stopUsingItem();
                    ((RangedAttackMob)this.actor).performRangedAttack(livingEntity, BowItem.getPowerForTime((int)i));
                    this.cooldown = this.attackInterval;
                }
            } else {
                int cooldown;
                this.cooldown = cooldown = this.cooldown - 1;
                if (cooldown <= 0 && this.targetSeeingTicker >= -60 && this.actor.getItemBySlot(EquipmentSlot.MAINHAND).is(Items.BOW)) {
                    this.actor.startUsingItem(ProjectileUtil.getWeaponHoldingHand(this.actor, (Item)Items.BOW));
                }
            }
        }
    }
}

