/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.SequencedMap;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.layers.WolfCollarLayer;
import net.minecraft.resources.ResourceLocation;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.compat.IrisCompat;
import net.raphimc.immediatelyfast.feature.core.BufferAllocatorPool;

public class BatchableBufferSource
extends MultiBufferSource.BufferSource
implements AutoCloseable {
    private static final ByteBufferBuilder FALLBACK_BUFFER = new ByteBufferBuilder(0);
    protected final Reference2ObjectMap<RenderType, ReferenceSet<BufferBuilder>> pendingBuffers = new Reference2ObjectLinkedOpenHashMap();
    protected final ReferenceSet<RenderType> activeLayers = new ReferenceLinkedOpenHashSet();
    protected boolean drawFallbackLayersFirst = false;

    public BatchableBufferSource() {
        this((SequencedMap<RenderType, ByteBufferBuilder>)Object2ObjectSortedMaps.emptyMap());
    }

    public BatchableBufferSource(SequencedMap<RenderType, ByteBufferBuilder> layerBuffers) {
        this(FALLBACK_BUFFER, layerBuffers);
    }

    public BatchableBufferSource(ByteBufferBuilder fallbackBuffer, SequencedMap<RenderType, ByteBufferBuilder> layerBuffers) {
        super(fallbackBuffer, layerBuffers);
    }

    public VertexConsumer getBuffer(RenderType layer) {
        BufferBuilder bufferBuilder;
        boolean hasBufferForRenderLayer;
        if (!this.drawFallbackLayersFirst && this.lastSharedType != null && this.lastSharedType != layer && !this.fixedBuffers.containsKey(this.lastSharedType)) {
            this.drawFallbackLayersFirst = true;
        }
        if (IrisCompat.IRIS_LOADED) {
            IrisCompat.skipExtension.set(!IrisCompat.isRenderingLevel.getAsBoolean());
        }
        boolean bl = hasBufferForRenderLayer = layer.canConsolidateConsecutiveGeometry() && this.pendingBuffers.containsKey((Object)layer);
        if (!layer.canConsolidateConsecutiveGeometry()) {
            bufferBuilder = new BufferBuilder(this.getNextBufferAllocator(), layer.mode(), layer.format());
            this.lastSharedType = layer;
        } else if (hasBufferForRenderLayer) {
            bufferBuilder = (BufferBuilder)((ReferenceSet)this.pendingBuffers.get((Object)layer)).iterator().next();
        } else if (this.fixedBuffers.containsKey(layer)) {
            bufferBuilder = new BufferBuilder((ByteBufferBuilder)this.fixedBuffers.get(layer), layer.mode(), layer.format());
        } else {
            bufferBuilder = new BufferBuilder(this.getNextBufferAllocator(), layer.mode(), layer.format());
            this.lastSharedType = layer;
        }
        if (IrisCompat.IRIS_LOADED) {
            IrisCompat.skipExtension.set(false);
        }
        if (!hasBufferForRenderLayer) {
            ((ReferenceSet)this.pendingBuffers.computeIfAbsent((Object)layer, k -> new ReferenceLinkedOpenHashSet())).add((Object)bufferBuilder);
        }
        if (hasBufferForRenderLayer) {
            if ((ImmediatelyFast.config.debug_only_use_last_usage_for_batch_ordering || layer.name.contains("immediatelyfast:renderlast")) && this.activeLayers.contains((Object)layer)) {
                this.activeLayers.remove((Object)layer);
                this.activeLayers.add((Object)layer);
            }
        } else {
            this.activeLayers.add((Object)layer);
        }
        return bufferBuilder;
    }

    public void endLastBatch() {
        this.lastSharedType = null;
        this.drawFallbackLayersFirst = false;
        int sortedLayersLength = 0;
        RenderType[] sortedLayers = new RenderType[this.activeLayers.size()];
        for (RenderType layer : this.activeLayers) {
            if (this.fixedBuffers.containsKey(layer)) continue;
            sortedLayers[sortedLayersLength++] = layer;
        }
        if (sortedLayersLength == 0) {
            return;
        }
        Arrays.sort(sortedLayers, (l1, l2) -> Integer.compare(this.getLayerOrder((RenderType)l1), this.getLayerOrder((RenderType)l2)));
        for (int i = 0; i < sortedLayersLength; ++i) {
            this.endBatch(sortedLayers[i]);
        }
    }

    public void endBatch() {
        if (this.activeLayers.isEmpty()) {
            this.close();
            return;
        }
        this.endLastBatch();
        for (RenderType layer : this.fixedBuffers.keySet()) {
            this.endBatch(layer);
        }
    }

    public void endBatch(RenderType layer) {
        if (this.drawFallbackLayersFirst) {
            this.endLastBatch();
        }
        this.drawDirect(layer);
    }

    @Override
    public void close() {
        this.lastSharedType = null;
        this.drawFallbackLayersFirst = false;
        for (RenderType layer : this.activeLayers) {
            for (BufferBuilder bufferBuilder : this.getBufferBuilder(layer)) {
                bufferBuilder.build();
                BufferAllocatorPool.returnBufferAllocatorSafe(bufferBuilder.buffer);
            }
        }
        this.activeLayers.clear();
        this.pendingBuffers.clear();
    }

    public void drawDirect(RenderType layer) {
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(false);
        }
        this.activeLayers.remove((Object)layer);
        for (BufferBuilder bufferBuilder : this.getBufferBuilder(layer)) {
            ByteBufferBuilder prevBufferAllocator = this.sharedBuffer;
            this.sharedBuffer = bufferBuilder.buffer;
            this.endBatch(layer, bufferBuilder);
            this.sharedBuffer = prevBufferAllocator;
            BufferAllocatorPool.returnBufferAllocatorSafe(bufferBuilder.buffer);
        }
        this.pendingBuffers.remove((Object)layer);
        if (this.lastSharedType == layer) {
            this.lastSharedType = null;
        }
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(true);
        }
    }

    public boolean hasActiveLayers() {
        return !this.activeLayers.isEmpty();
    }

    protected Set<BufferBuilder> getBufferBuilder(RenderType layer) {
        if (this.pendingBuffers.containsKey((Object)layer)) {
            return (Set)this.pendingBuffers.get((Object)layer);
        }
        return Collections.emptySet();
    }

    protected int getLayerOrder(RenderType layer) {
        if (layer == null) {
            return Integer.MAX_VALUE;
        }
        if (layer instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType multiPhase = (RenderType.CompositeRenderType)layer;
            ResourceLocation textureId = multiPhase.state().textureState.cutoutTexture().orElse(null);
            if (textureId != null) {
                if (textureId.getPath().startsWith("textures/entity/horse/")) {
                    String horseTexturePath = textureId.getPath().substring("textures/entity/horse/".length());
                    if (horseTexturePath.startsWith("horse_markings")) {
                        return 2;
                    }
                    if (horseTexturePath.startsWith("armor/")) {
                        return 3;
                    }
                    return 1;
                }
                if (textureId.toString().startsWith("minecraft:textures/entity/wolf/")) {
                    if (textureId.equals((Object)WolfCollarLayer.WOLF_COLLAR_LOCATION)) {
                        return 2;
                    }
                    return 1;
                }
                if (textureId.equals((Object)Sheets.ARMOR_TRIMS_SHEET)) {
                    return 1;
                }
                if (layer.name.startsWith("text") || layer.name.startsWith("neoforge_text") || layer.name.startsWith("forge_text")) {
                    if (textureId.getNamespace().equals("minecraft")) {
                        return 2;
                    }
                    return 1;
                }
            }
        }
        if (!layer.sortOnUpload()) {
            return Integer.MIN_VALUE;
        }
        return 0x7FFFFFFE;
    }

    private ByteBufferBuilder getNextBufferAllocator() {
        if (this.sharedBuffer != FALLBACK_BUFFER && this.lastSharedType == null && this.sharedBuffer.pointer != 0L) {
            return this.sharedBuffer;
        }
        return BufferAllocatorPool.borrowBufferAllocator();
    }
}

