/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.incineratorstryhard.mixin;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.effect.Wave_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Player_Ceraunus_Entity;
import com.github.L_Ender.cataclysm.init.ModDataComponents;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.items.Ceraunus;
import com.rinko1231.incineratorstryhard.config.IncineratorsTryHardConfig;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Ceraunus.class})
public abstract class CeraunusMixin
extends Item {
    public CeraunusMixin(Item.Properties properties) {
        super(properties);
    }

    @Unique
    private static float _1211$getPowerForTime(int p_40662_) {
        float f = (float)p_40662_ / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Shadow
    public abstract int getUseDuration(@NotNull ItemStack var1, @NotNull LivingEntity var2);

    @Inject(method={"releaseUsing"}, at={@At(value="HEAD")}, cancellable=true)
    public void ModifyReleaseUsing(ItemStack p_43394_, Level p_43395_, LivingEntity p_43396_, int p_43397_, CallbackInfo ci) {
        if (p_43396_ instanceof Player) {
            Player player = (Player)p_43396_;
            int i = this.getUseDuration(p_43394_, p_43396_) - p_43397_;
            float f = CeraunusMixin._1211$getPowerForTime(i);
            if (!((double)f < (Double)IncineratorsTryHardConfig.ceraunusChargingTime.get()) && !p_43395_.isClientSide) {
                float yawRadians = (float)Math.toRadians(90.0f + player.getYRot());
                double vecX = Math.cos(yawRadians);
                double vecZ = Math.sin(yawRadians);
                double vec = 2.0;
                double spawnX = p_43396_.getX() + vecX * vec;
                double spawnY = p_43396_.getY();
                double spawnZ = p_43396_.getZ() + vecZ * vec;
                int numberOfWaves = (Integer)IncineratorsTryHardConfig.ceraunusNumberOfWaves.get();
                float angleStep = 25.0f;
                double firstAngleOffset = (double)(numberOfWaves - 1) / 2.0 * (double)angleStep;
                if (p_43396_.isShiftKeyDown()) {
                    player.getCooldowns().addCooldown((Item)this, CMConfig.CeraunusCooldown);
                    p_43395_.playSound((Player)null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.HEAVY_SMASH.get(), SoundSource.PLAYERS, 0.6f, 1.0f);
                    for (int k = 0; k < numberOfWaves; ++k) {
                        double angle = (double)player.getYRot() - firstAngleOffset + (double)((float)k * angleStep);
                        double rad = Math.toRadians(angle);
                        double dx = -Math.sin(rad);
                        double dz = Math.cos(rad);
                        Wave_Entity WaveEntity = new Wave_Entity(p_43395_, p_43396_, ((Integer)IncineratorsTryHardConfig.ceraunusLifeOfWaves.get()).intValue(), (float)CMConfig.CeraunusWaveDamage);
                        WaveEntity.setPos(spawnX, spawnY, spawnZ);
                        WaveEntity.setState(1);
                        WaveEntity.setYRot(-((float)(Mth.atan2((double)dx, (double)dz) * 57.29577951308232)));
                        p_43396_.level().addFreshEntity((Entity)WaveEntity);
                    }
                } else if (p_43394_.get((Supplier)ModDataComponents.THROWN_ANCHOR) == null && p_43395_.getWorldBorder().isWithinBounds(player.blockPosition())) {
                    Player_Ceraunus_Entity launchedBlock = new Player_Ceraunus_Entity(p_43395_, (LivingEntity)player);
                    launchedBlock.setBaseDamage((double)((float)player.getAttributeValue(Attributes.ATTACK_DAMAGE)));
                    launchedBlock.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, ((Double)IncineratorsTryHardConfig.ceraunusThrownVelocity.get()).floatValue(), 1.0f);
                    if (p_43395_.addFreshEntity((Entity)launchedBlock)) {
                        p_43394_.set((Supplier)ModDataComponents.THROWN_ANCHOR, (Object)launchedBlock.getUUID());
                    }
                }
            }
        }
        ci.cancel();
    }
}

