/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.incineratorstryhard.mixin;

import com.github.L_Ender.cataclysm.entity.projectile.Tidal_Hook_Entity;
import com.github.L_Ender.cataclysm.init.ModDataAttachments;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.items.Tidal_Claws;
import com.rinko1231.incineratorstryhard.config.IncineratorsTryHardConfig;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Tidal_Claws.class}, remap=false)
public abstract class TidalClawsMixin
extends Item {
    public TidalClawsMixin(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Shadow
    protected abstract boolean isCharged(Player var1, ItemStack var2);

    @Shadow
    public abstract boolean launchTendonsAt(ItemStack var1, LivingEntity var2, Entity var3);

    @Overwrite
    public InteractionResultHolder<ItemStack> use(Level level, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        boolean flag = (Boolean)user.getData((Supplier)ModDataAttachments.HOOK_FALLING);
        if (!level.isClientSide && !flag) {
            double maxRange = (Double)IncineratorsTryHardConfig.TidalClawsHookMaxRange.get();
            double maxSpeed = (Double)IncineratorsTryHardConfig.TidalClawsHookMaxSpeed.get();
            Tidal_Hook_Entity hookshot = new Tidal_Hook_Entity(level, (LivingEntity)user, ItemStack.EMPTY);
            hookshot.setProperties(stack, maxRange, maxSpeed, user.getXRot(), user.getYRot(), 0.0f, 1.5f * (float)(maxSpeed / 10.0));
            level.addFreshEntity((Entity)hookshot);
        }
        user.startUsingItem(hand);
        user.setData((Supplier)ModDataAttachments.HOOK_FALLING, (Object)true);
        return super.use(level, user, hand);
    }

    @Inject(method={"onLeftClick"}, at={@At(value="HEAD")}, cancellable=true)
    public void onLeftClickTweak(ItemStack stack, LivingEntity playerIn, CallbackInfoReturnable<Boolean> cir) {
        if (stack.is((Item)ModItems.TIDAL_CLAWS.get()) && (!(playerIn instanceof Player) || this.isCharged((Player)playerIn, stack))) {
            Level worldIn = playerIn.level();
            Entity closestValid = null;
            Vec3 playerEyes = playerIn.getEyePosition(1.0f);
            BlockHitResult hitresult = worldIn.clip(new ClipContext(playerEyes, playerEyes.add(playerIn.getLookAngle().scale(((Double)IncineratorsTryHardConfig.TidalClawsTentacleFirstRange.get()).doubleValue())), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)playerIn));
            if (hitresult instanceof EntityHitResult) {
                Entity entity = ((EntityHitResult)hitresult).getEntity();
                if (!entity.equals((Object)playerIn) && !playerIn.isAlliedTo(entity) && !entity.isAlliedTo((Entity)playerIn) && entity instanceof Mob && playerIn.hasLineOfSight(entity)) {
                    closestValid = entity;
                }
            } else {
                for (Entity entity : worldIn.getEntitiesOfClass(LivingEntity.class, playerIn.getBoundingBox().inflate(((Double)IncineratorsTryHardConfig.TidalClawsTentacleSecondRange.get()).doubleValue()))) {
                    if (entity.equals((Object)playerIn) || playerIn.isAlliedTo(entity) || entity.isAlliedTo((Entity)playerIn) || !(entity instanceof Mob) || !playerIn.hasLineOfSight(entity) || closestValid != null && !(playerIn.distanceTo(entity) < playerIn.distanceTo(closestValid))) continue;
                    closestValid = entity;
                }
            }
            cir.setReturnValue((Object)this.launchTendonsAt(stack, playerIn, closestValid));
        } else {
            cir.setReturnValue((Object)false);
        }
    }
}

