/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.internal;

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.container.FakeConfigContainer;
import com.iafenvoy.jupiter.interfaces.IConfigHandler;
import com.iafenvoy.jupiter.render.internal.JupiterConfigListWidget;
import com.iafenvoy.jupiter.render.screen.ServerConfigScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class JupiterConfigListScreen
extends Screen {
    private final Screen parent;
    private JupiterConfigListWidget widget;
    private boolean initialized = false;

    public JupiterConfigListScreen(Screen parent) {
        super((Component)Component.translatable((String)"jupiter.screen.config_list.title"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        if (this.initialized) {
            this.widget.setRectangle(this.width - 80, this.height - 70, 40, 64);
        } else {
            this.initialized = true;
            this.widget = new JupiterConfigListWidget(this, this.minecraft, this.width - 80, this.height - 70, 64, 24);
            this.widget.setX(40);
            this.widget.update();
        }
        this.addWidget((GuiEventListener)this.widget);
        this.addField((AbstractWidget)Button.builder((Component)Component.translatable((String)"jupiter.screen.back"), button -> this.onClose()).bounds(40, 40, 100, 20).build());
        this.addField((AbstractWidget)Button.builder((Component)Component.translatable((String)"jupiter.screen.open"), button -> {
            IConfigHandler patt0$temp;
            JupiterConfigListWidget.ConfigEntry handler = (JupiterConfigListWidget.ConfigEntry)this.widget.getSelected();
            if (handler != null && (patt0$temp = handler.getConfigContainer()) instanceof AbstractConfigContainer) {
                AbstractConfigContainer container = (AbstractConfigContainer)patt0$temp;
                this.minecraft.setScreen((Screen)new ServerConfigScreen(this, this.getServerConfig(container)));
            }
        }).bounds(150, 40, 100, 20).build());
    }

    public void addField(AbstractWidget drawable) {
        this.addRenderableOnly((Renderable)drawable);
        this.addWidget((GuiEventListener)drawable);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.widget.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }

    public void select(JupiterConfigListWidget.ConfigEntry entry) {
        this.widget.setSelected((AbstractSelectionList.Entry)entry);
    }

    public void onClose() {
        super.onClose();
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    private AbstractConfigContainer getServerConfig(AbstractConfigContainer container) {
        if (!this.connectedToDedicatedServer()) {
            return container;
        }
        return new FakeConfigContainer(container);
    }

    public boolean connectedToDedicatedServer() {
        assert (this.minecraft != null);
        ClientPacketListener handler = this.minecraft.getConnection();
        IntegratedServer server = this.minecraft.getSingleplayerServer();
        return handler != null && handler.getConnection().isConnected() && (server == null || server.isPublished());
    }
}

