/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.effect;

import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public class SundayFeverEffect
extends MagicMobEffect {
    private static final NoteBlockInstrument[] MUSIC_INSTRUMENTS = new NoteBlockInstrument[]{NoteBlockInstrument.HARP, NoteBlockInstrument.BASEDRUM, NoteBlockInstrument.SNARE, NoteBlockInstrument.HAT, NoteBlockInstrument.BASS, NoteBlockInstrument.FLUTE, NoteBlockInstrument.BELL, NoteBlockInstrument.GUITAR, NoteBlockInstrument.CHIME, NoteBlockInstrument.XYLOPHONE, NoteBlockInstrument.IRON_XYLOPHONE, NoteBlockInstrument.COW_BELL, NoteBlockInstrument.DIDGERIDOO, NoteBlockInstrument.BIT, NoteBlockInstrument.BANJO, NoteBlockInstrument.PLING};
    private static final int[][] RIFF_PATTERNS = new int[][]{{0, 4, 7, 12}, {0, 3, 7, 10}, {0, 5, 7, 12}, {0, 2, 4, 5, 7, 9}};
    private static final Map<UUID, int[]> activeRiffs = new HashMap<UUID, int[]>();
    private static final Map<UUID, Integer> riffIndexMap = new HashMap<UUID, Integer>();

    public SundayFeverEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 6 == 0;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide) {
            UUID id = entity.getUUID();
            RandomSource random = entity.getRandom();
            activeRiffs.computeIfAbsent(id, uuid -> RIFF_PATTERNS[random.nextInt(RIFF_PATTERNS.length)]);
            riffIndexMap.putIfAbsent(id, 0);
            int[] riff = activeRiffs.get(id);
            int riffIndex = riffIndexMap.get(id);
            int note = riff[riffIndex];
            riffIndexMap.put(id, (riffIndex + 1) % riff.length);
            float pitch = (float)Math.pow(2.0, (double)note / 12.0);
            double baseShake = 0.1 + (double)Math.abs(note) * 0.05;
            double verticalShake = note > 0 ? baseShake * 1.5 : baseShake * 0.5;
            float minYawChange = 70.0f;
            float maxYawChange = 180.0f;
            float yawOffset = (minYawChange + random.nextFloat() * (maxYawChange - minYawChange)) * (float)(random.nextBoolean() ? 1 : -1);
            entity.setYRot(entity.getYRot() + yawOffset);
            entity.setYBodyRot(entity.getYRot());
            entity.setYHeadRot(entity.getYRot());
            double dx = (random.nextDouble() - 0.5) * baseShake;
            double dy = (random.nextDouble() - 0.5) * verticalShake * 0.8;
            double dz = (random.nextDouble() - 0.5) * baseShake;
            entity.setDeltaMovement(entity.getDeltaMovement().add(dx, dy, dz));
            NoteBlockInstrument instrument = MUSIC_INSTRUMENTS[random.nextInt(MUSIC_INSTRUMENTS.length)];
            entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)instrument.getSoundEvent().value(), entity.getSoundSource(), 0.08f, pitch);
            if (random.nextFloat() < 0.4f) {
                ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ParticleTypes.FIREWORK, entity.getX(), entity.getY() + 1.0, entity.getZ(), 2 + random.nextInt(4), 0.2, 0.4, 0.2, 0.05);
            }
        }
        return true;
    }

    public void onEffectRemoved(LivingEntity entity, int amplifier) {
        UUID id = entity.getUUID();
        activeRiffs.remove(id);
        riffIndexMap.remove(id);
    }
}

