/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.entity;

import com.rinko1231.majospellenchantment.init.EntityRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.particle.ZapParticleOption;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DeathChainLightning
extends AbstractMagicProjectile {
    List<Entity> allVictims = new ArrayList<Entity>();
    Entity initialVictim;
    public int maxConnections = 1;
    public float range = 3.0f;
    private static final Supplier<AbstractSpell> SPELL = SpellRegistry.CHAIN_LIGHTNING_SPELL;
    int hits;
    boolean deathChainMode;
    int lingerTicks;
    float bonusDamage;
    float bonusDamageGrowth;
    Entity lastVictim;

    public void impactParticles(double x, double y, double z) {
    }

    public void trailParticles() {
    }

    public DeathChainLightning(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
        this.setNoGravity(true);
        this.noPhysics = true;
        this.deathChainMode = false;
        this.lingerTicks = 20;
        this.bonusDamage = 0.0f;
    }

    public DeathChainLightning(Level level, Entity owner, Entity initialVictim) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.DEATH_CHAIN_LIGHTNING.get()), level);
        this.setOwner(owner);
        this.setPos(initialVictim.position());
        this.initialVictim = initialVictim;
    }

    public DeathChainLightning asDeathChain(int baseConnections, float baseRange, float extraDamage, int minLinger, float bonusDamageGrowth) {
        this.deathChainMode = true;
        this.maxConnections = Math.max(1, baseConnections);
        this.range = Math.max(2.0f, baseRange);
        this.bonusDamage = Math.max(0.0f, extraDamage);
        this.bonusDamageGrowth = bonusDamageGrowth;
        this.lingerTicks = Math.max(10, minLinger);
        return this;
    }

    public void tick() {
        int f;
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        if (this.lingerTicks > 0) {
            --this.lingerTicks;
        }
        if ((f = this.tickCount - 1) % 6 == 0) {
            if (f == 0) {
                if (this.initialVictim != null && !this.allVictims.contains(this.initialVictim)) {
                    this.doHurtOnce(this.initialVictim);
                    this.allVictims.add(this.initialVictim);
                    this.lastVictim = this.initialVictim;
                }
            } else if (this.lastVictim != null && this.hits < this.maxConnections) {
                List candidates = this.level().getEntitiesOfClass(LivingEntity.class, this.lastVictim.getBoundingBox().inflate((double)this.range), this::canHitEntity);
                if (!candidates.isEmpty()) {
                    candidates.sort(Comparator.comparingDouble(o -> o.distanceToSqr(this.lastVictim)));
                    LivingEntity victim = (LivingEntity)candidates.getFirst();
                    this.doZap(this.lastVictim, victim);
                    this.allVictims.add((Entity)victim);
                    this.lastVictim = victim;
                } else {
                    this.discard();
                }
            } else {
                this.discard();
            }
            if (this.hits >= this.maxConnections || this.lingerTicks <= 0) {
                this.discard();
            }
        }
    }

    private void doZap(Entity src, LivingEntity victim) {
        Vec3 start = src.position().add(0.0, (double)(src.getBbHeight() / 2.0f), 0.0);
        Vec3 dest = victim.position().add(0.0, (double)(victim.getBbHeight() / 2.0f), 0.0);
        this.doHurtOnce((Entity)victim);
        victim.playSound((SoundEvent)SoundRegistry.CHAIN_LIGHTNING_CHAIN.get(), 2.0f, 1.0f);
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)new ZapParticleOption(dest), start.x, start.y, start.z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void doHurtOnce(Entity victim) {
        ++this.hits;
        float amount = this.damage + this.bonusDamage;
        DamageSources.applyDamage((Entity)victim, (float)amount, (DamageSource)SPELL.get().getDamageSource((Entity)this, this.getOwner()));
        MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleHelper.ELECTRICITY, (double)victim.getX(), (double)(victim.getY() + (double)(victim.getBbHeight() / 2.0f)), (double)victim.getZ(), (int)10, (double)(victim.getBbWidth() / 3.0f), (double)(victim.getBbHeight() / 3.0f), (double)(victim.getBbWidth() / 3.0f), (double)0.1, (boolean)false);
    }

    public void onKill(LivingEntity victim) {
        if (!this.deathChainMode) {
            return;
        }
        ++this.maxConnections;
        this.bonusDamage += this.bonusDamageGrowth > 0.0f ? this.bonusDamageGrowth : 1.0f;
        this.lingerTicks = Math.max(this.lingerTicks, 10);
        this.lastVictim = victim;
    }

    protected boolean canHitEntity(Entity target) {
        return target instanceof LivingEntity && !DamageSources.isFriendlyFireBetween((Entity)target, (Entity)this.getOwner()) && target != this.getOwner() && !this.hasAlreadyZapped(target) && super.canHitEntity(target);
    }

    public boolean hasAlreadyZapped(Entity entity) {
        return this.allVictims.contains(entity);
    }

    public float getSpeed() {
        return 0.0f;
    }

    public Optional<Holder<SoundEvent>> getImpactSound() {
        return Optional.empty();
    }

    public boolean shouldBeSaved() {
        return false;
    }
}

