/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.CommonHooks;

public class AriaAnthemEvent {
    @SubscribeEvent
    public void onSpellPreCast(SpellPreCastEvent event) {
        double bonus;
        if (!((Boolean)MajoSpellEnchantmentConfig.nocturneAriaEnabled.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AttributeInstance castTimeReduction = player2.getAttribute((Holder)AttributeRegistry.CAST_TIME_REDUCTION);
        if (castTimeReduction == null) {
            return;
        }
        castTimeReduction.removeModifier(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"nocturne_aria_bonus"));
        castTimeReduction.removeModifier(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"daylight_anthem_bonus"));
        ItemStack spellbook = Utils.getPlayerSpellbookStack((Player)player2);
        if (spellbook == null) {
            return;
        }
        int nocturneLevel = spellbook.getEnchantmentLevel((Holder)Objects.requireNonNull(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT)).getOrThrow(EnchantmentRegistry.NOCTURNE_ARIA_ENCHANT));
        int daylightLevel = spellbook.getEnchantmentLevel((Holder)Objects.requireNonNull(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT)).getOrThrow(EnchantmentRegistry.DAYLIGHT_ANTHEM_ENCHANT));
        boolean canSeeSky = player2.level().canSeeSky(player2.blockPosition());
        boolean isNight = player2.level().isNight();
        boolean isDay = player2.level().isDay();
        if (nocturneLevel > 0 && (isNight || !canSeeSky)) {
            bonus = (Double)MajoSpellEnchantmentConfig.nocturneAriaBonusPerLevel.get() * (double)nocturneLevel;
            castTimeReduction.addTransientModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"nocturne_aria_bonus"), bonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        if (daylightLevel > 0 && isDay && canSeeSky) {
            bonus = (Double)MajoSpellEnchantmentConfig.daylightAnthemBonusPerLevel.get() * (double)daylightLevel;
            castTimeReduction.addTransientModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"daylight_anthem_bonus"), bonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
    }
}

