/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class BloodManaEvent {
    @SubscribeEvent
    public void onPlayerDamaged(LivingDamageEvent.Post event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.bloodManaEnabled.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (event.getSource().is(DamageTypes.FELL_OUT_OF_WORLD)) {
            return;
        }
        int enchantLevel = player.getItemBySlot(EquipmentSlot.CHEST).getEnchantmentLevel((Holder)player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentRegistry.BLOOD_MANA_ENCHANT));
        if (enchantLevel <= 0) {
            return;
        }
        float damageTaken = event.getNewDamage();
        if (damageTaken <= 0.0f) {
            return;
        }
        double bloodManaRatioPerLevel = (Double)MajoSpellEnchantmentConfig.bloodManaRatioPerLevel.get();
        double capPerLevel = (Double)MajoSpellEnchantmentConfig.bloodManaCapPerLevel.get();
        double manaRestore = (double)damageTaken * (bloodManaRatioPerLevel * (double)enchantLevel);
        double cap = capPerLevel * (double)enchantLevel;
        if ((manaRestore = Math.min(manaRestore, cap)) <= 0.0) {
            return;
        }
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)player);
        magicData.addMana((float)manaRestore);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncManaPacket(magicData), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

