/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.events.SpellDamageEvent;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.entity.spells.magic_missile.MagicMissileProjectile;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.CommonHooks;

public class ExcitatioArcanaEvent {
    private static final String CD_KEY = "majospell_excitatio_arcana_cd";

    @SubscribeEvent
    public void onSpellDamage(SpellDamageEvent event) {
        long nextAllowed;
        LivingEntity target = event.getEntity();
        if (target == null || target.level().isClientSide()) {
            return;
        }
        SpellDamageSource sds = event.getSpellDamageSource();
        if (sds == null) {
            return;
        }
        Entity src = sds.getEntity();
        if (!(src instanceof Player)) {
            return;
        }
        Player player = (Player)src;
        ItemStack spellbook = Utils.getPlayerSpellbookStack((Player)player);
        if (spellbook == null || spellbook.isEmpty()) {
            return;
        }
        int enchantmentLevel = spellbook.getEnchantmentLevel((Holder)Objects.requireNonNull(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT)).getOrThrow(EnchantmentRegistry.EXCITATIO_ARCANA_ENCHANT));
        if (enchantmentLevel <= 0) {
            return;
        }
        int cooldownSeconds = Math.max(8, 20 - 4 * (enchantmentLevel - 1));
        int cooldownTicks = cooldownSeconds * 20;
        long now = target.level().getGameTime();
        if (now < (nextAllowed = player.getPersistentData().getLong(CD_KEY))) {
            return;
        }
        player.getPersistentData().putLong(CD_KEY, now + (long)cooldownTicks);
        float shardDamage = Math.max(1.0f, event.getAmount() * 0.1f * (float)enchantmentLevel);
        Vec3 origin = target.position().add(0.0, (double)target.getBbHeight() * 0.5, 0.0);
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ExcitatioArcanaEvent.spawnExcitatioMissiles(server, (LivingEntity)player, origin, shardDamage);
        }
    }

    private static void spawnExcitatioMissiles(ServerLevel level, LivingEntity owner, Vec3 origin, float damage) {
        int count = 6;
        double speed = 0.35;
        float pitchUp = (float)Math.toRadians(5.0);
        for (int i = 0; i < 6; ++i) {
            float yaw = (float)((double)i * 1.0471975511965976);
            Vec3 dir = new Vec3(0.0, 0.0, 1.0).xRot(pitchUp).yRot(yaw).normalize();
            MagicMissileProjectile proj = new MagicMissileProjectile((Level)level, owner);
            proj.setNoGravity(false);
            proj.setDamage(damage);
            proj.setDeltaMovement(dir.scale(0.35));
            Vec3 spawn = origin.add(dir.scale(0.25));
            float yRot = (float)Math.toDegrees(yaw);
            float xRot = (float)(-Math.toDegrees(pitchUp));
            proj.moveTo(spawn.x, spawn.y, spawn.z, yRot, xRot);
            level.addFreshEntity((Entity)proj);
        }
    }
}

