/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.events.SpellDamageEvent;
import io.redspace.ironsspellbooks.api.events.SpellHealEvent;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.CommonHooks;

public class GentleGraveyardKeeperEvent {
    @SubscribeEvent
    public void onSpellDamage(SpellDamageEvent event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.gentleGraveyardKeeperEnabled.get()).booleanValue()) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (target == null || target.level().isClientSide()) {
            return;
        }
        if (event.getAmount() <= 0.0f) {
            return;
        }
        if (!target.getType().is(EntityTypeTags.UNDEAD)) {
            return;
        }
        if (event.getSpellDamageSource() == null || event.getSpellDamageSource().spell() == null || event.getSpellDamageSource().spell().getSchoolType() != SchoolRegistry.HOLY.get()) {
            return;
        }
        Entity attacker = event.getSpellDamageSource().getEntity();
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        ItemStack spellbook = Utils.getPlayerSpellbookStack((Player)player);
        if (spellbook == null || spellbook.isEmpty()) {
            return;
        }
        int level = spellbook.getEnchantmentLevel((Holder)Objects.requireNonNull(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT)).getOrThrow(EnchantmentRegistry.GENTLE_GRAVEYARD_KEEPER_ENCHANT));
        if (level <= 0) {
            return;
        }
        target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 60 + level * 20, 0));
    }

    @SubscribeEvent
    public void onSpellHeal(SpellHealEvent event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.gentleGraveyardKeeperEnabled.get()).booleanValue()) {
            return;
        }
        LivingEntity caster = event.getEntity();
        LivingEntity target = event.getTargetEntity();
        if (caster == null || target == null) {
            return;
        }
        if (target.level().isClientSide()) {
            return;
        }
        if (event.getSchoolType() != SchoolRegistry.HOLY.get()) {
            return;
        }
        if (!(caster instanceof Player)) {
            return;
        }
        Player player = (Player)caster;
        ItemStack spellbook = Utils.getPlayerSpellbookStack((Player)player);
        if (spellbook == null || spellbook.isEmpty()) {
            return;
        }
        int level = spellbook.getEnchantmentLevel((Holder)Objects.requireNonNull(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT)).getOrThrow(EnchantmentRegistry.GENTLE_GRAVEYARD_KEEPER_ENCHANT));
        if (level <= 0) {
            return;
        }
        target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 60 + level * 20, 0));
    }
}

