/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;

public class HopelessPowerEvent {
    @SubscribeEvent
    public void onSpellCast(SpellPreCastEvent event) {
        double bonusMultiplier;
        if (!((Boolean)MajoSpellEnchantmentConfig.hopelessPowerEnabled.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AttributeInstance spellPower = player2.getAttribute((Holder)AttributeRegistry.SPELL_POWER);
        if (spellPower == null) {
            return;
        }
        spellPower.removeModifier(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"hopeless_power_bonus"));
        HolderLookup.RegistryLookup enchants = player2.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        int level = player2.getItemBySlot(EquipmentSlot.CHEST).getEnchantmentLevel((Holder)enchants.getOrThrow(EnchantmentRegistry.HOPELESS_POWER_ENCHANT));
        if (level <= 0) {
            return;
        }
        double thresholdStart = (Double)MajoSpellEnchantmentConfig.hopelessPowerThresholdStart.get();
        double thresholdMax = (Double)MajoSpellEnchantmentConfig.hopelessPowerThresholdMax.get();
        double maxBonusPerLevel = (Double)MajoSpellEnchantmentConfig.hopelessPowerBonusPerLevel.get();
        double hpPercent = player2.getHealth() / player2.getMaxHealth();
        if (hpPercent > thresholdStart) {
            return;
        }
        double maxBonus = maxBonusPerLevel * (double)level;
        if (hpPercent <= thresholdMax) {
            bonusMultiplier = maxBonus;
        } else {
            double range = thresholdStart - thresholdMax;
            double scale = (thresholdStart - hpPercent) / range;
            bonusMultiplier = maxBonus * scale;
        }
        if (bonusMultiplier > 0.0) {
            spellPower.removeModifier(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"hopeless_power_bonus"));
            spellPower.addTransientModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"hopeless_power_bonus"), bonusMultiplier, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
    }
}

