/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.events.SpellDamageEvent;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.CommonHooks;

public class IceFireSongEvent {
    @SubscribeEvent
    public void onSpellDamage(SpellDamageEvent event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.iceFireSongEnabled.get()).booleanValue()) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (target == null || target.level().isClientSide()) {
            return;
        }
        SpellDamageSource sds = event.getSpellDamageSource();
        if (sds == null || sds.spell() == null) {
            return;
        }
        Entity caster = sds.getEntity();
        if (!(caster instanceof Player)) {
            return;
        }
        Player player = (Player)caster;
        ItemStack spellbook = Utils.getPlayerSpellbookStack((Player)player);
        if (spellbook == null || spellbook.isEmpty()) {
            return;
        }
        int enchantmentLevel = spellbook.getEnchantmentLevel((Holder)Objects.requireNonNull(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT)).getOrThrow(EnchantmentRegistry.ICE_FIRE_SONG_ENCHANT));
        if (enchantmentLevel <= 0) {
            return;
        }
        SchoolType school = sds.spell().getSchoolType();
        float amount = event.getAmount();
        boolean modified = false;
        float MaxDamageAmountBonus = 1.0f + ((Double)MajoSpellEnchantmentConfig.iceFireSongExtraDamageRatioPerLevel.get()).floatValue() * (float)enchantmentLevel;
        if (school == SchoolRegistry.ICE.get() && target.isOnFire() && !target.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)) {
            amount *= MaxDamageAmountBonus;
            target.clearFire();
            modified = true;
        }
        if (school == SchoolRegistry.FIRE.get() && target instanceof LivingEntity) {
            LivingEntity le = target;
            int frozen = le.getTicksFrozen();
            int required = le.getTicksRequiredToFreeze();
            if (frozen > 0 && required > 0 && (double)frozen > 0.3 * (double)required) {
                double ratio = (double)frozen / (double)required;
                float mult = (float)Math.min((double)MaxDamageAmountBonus, 1.0 + (Double)MajoSpellEnchantmentConfig.iceFireSongExtraDamageRatioPerLevel.get() * ratio);
                amount *= mult;
                int thaw = Math.max(frozen / 2, required / 2);
                le.setTicksFrozen(Math.max(0, frozen - thaw));
                modified = true;
            }
        }
        if (modified) {
            event.setAmount(amount);
        }
    }
}

