/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.capabilities.magic.SummonedEntitiesCastData;
import io.redspace.ironsspellbooks.entity.mobs.SummonedSkeleton;
import io.redspace.ironsspellbooks.entity.mobs.SummonedZombie;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class LichKingEvent {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.lichKingEnabled.get()).booleanValue()) {
            return;
        }
        LivingEntity dead = event.getEntity();
        if (dead.level().isClientSide()) {
            return;
        }
        DamageSource src = event.getSource();
        if (src.getEntity() == null) {
            return;
        }
        Entity entity = src.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!dead.getType().is(EnchantmentRegistry.LICH_KING_TURNING_TAG)) {
            return;
        }
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        if (helmet == null || helmet.isEmpty()) {
            return;
        }
        int enchantmentLevel = helmet.getEnchantmentLevel((Holder)Objects.requireNonNull(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT)).getOrThrow(EnchantmentRegistry.DOMINION_HELM_ENCHANT));
        if (enchantmentLevel <= 0) {
            return;
        }
        Level level = dead.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if ((double)player.getRandom().nextFloat() > (Double)MajoSpellEnchantmentConfig.lichKingUndeadSummonPossibilityPerLevel.get() * (double)enchantmentLevel) {
            return;
        }
        SummonedSkeleton summon = server.random.nextDouble() < 0.3 ? new SummonedSkeleton((Level)server, (LivingEntity)player, true) : new SummonedZombie((Level)server, (LivingEntity)player, true);
        DifficultyInstance diff = server.getCurrentDifficultyAt(dead.blockPosition());
        summon.finalizeSpawn((ServerLevelAccessor)server, diff, MobSpawnType.MOB_SUMMONED, null);
        summon.setPos(dead.getX(), dead.getY(), dead.getZ());
        summon.setYRot(player.getYRot());
        summon.setOldPosAndRot();
        summon.setHealth(summon.getMaxHealth() * 0.5f);
        server.addFreshEntity((Entity)summon);
        SummonedEntitiesCastData castData = new SummonedEntitiesCastData();
        SummonManager.initSummon((Entity)player, (Entity)summon, (int)((Integer)MajoSpellEnchantmentConfig.lichKingUndeadDurationPerLevel.get() * enchantmentLevel), (SummonedEntitiesCastData)castData);
        server.playSound(null, dead.getX(), dead.getY(), dead.getZ(), (SoundEvent)SoundRegistry.RAISE_DEAD_FINISH.get(), player.getSoundSource(), 2.0f, 1.0f);
    }
}

