/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.events.ChangeManaEvent;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.bus.api.SubscribeEvent;

public class ManaMendingEvent {
    @SubscribeEvent
    public void onManaChanged(ChangeManaEvent event) {
        float newMana;
        if (!((Boolean)MajoSpellEnchantmentConfig.manaMendingEnabled.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player == null || player.level().isClientSide()) {
            return;
        }
        float oldMana = event.getOldMana();
        float consumed = oldMana - (newMana = event.getNewMana());
        if ((double)consumed < (Double)MajoSpellEnchantmentConfig.manaMendingThreshold.get()) {
            return;
        }
        int repairPoints = 1 + (int)Math.floor(consumed / 100.0f);
        ArrayList<ItemStack> targets = new ArrayList<ItemStack>();
        for (ItemStack armor : player.getArmorSlots()) {
            targets.add(armor);
        }
        targets.add(player.getMainHandItem());
        targets.add(player.getOffhandItem());
        for (ItemStack stack : targets) {
            int current;
            int repaired;
            int level;
            if (stack.isEmpty() || !stack.isDamageableItem() || !stack.isDamaged() || (level = ManaMendingEvent.getMendingLevel(stack, player)) <= 0 || (repaired = Math.max(0, (current = stack.getDamageValue()) - repairPoints)) == current) continue;
            stack.setDamageValue(repaired);
        }
    }

    private static int getMendingLevel(ItemStack stack, Player player) {
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)player.level().holderLookup(EnchantmentRegistry.MANA_MENDING_ENCHANT.registryKey()).getOrThrow(EnchantmentRegistry.MANA_MENDING_ENCHANT), (ItemStack)stack);
    }
}

