/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ManaReaperEvent {
    public static Holder<Enchantment> getHolder(Level level, ResourceKey<Enchantment> enchantment) {
        return level.holderLookup(enchantment.registryKey()).getOrThrow(enchantment);
    }

    public static Holder<Attribute> getHolder2(Level level, ResourceKey<Attribute> attr) {
        return level.holderLookup(attr.registryKey()).getOrThrow(attr);
    }

    @SubscribeEvent
    public void onMobDeath(LivingDeathEvent event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.manaReaperEnabled.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        ItemStack heldItem1 = serverPlayer.getMainHandItem();
        ItemStack heldItem2 = serverPlayer.getOffhandItem();
        int enchantLevel1 = EnchantmentHelper.getItemEnchantmentLevel(ManaReaperEvent.getHolder(serverPlayer.level(), EnchantmentRegistry.MANA_REAPER_ENCHANT), (ItemStack)heldItem1);
        int enchantLevel2 = EnchantmentHelper.getItemEnchantmentLevel(ManaReaperEvent.getHolder(serverPlayer.level(), EnchantmentRegistry.MANA_REAPER_ENCHANT), (ItemStack)heldItem2);
        int enchantLevel = Math.max(enchantLevel1, enchantLevel2);
        if (enchantLevel <= 0) {
            return;
        }
        double mobMaxHealth = event.getEntity().getMaxHealth();
        double factor = (Double)MajoSpellEnchantmentConfig.manaReaperRegenFactor.get();
        double capPerLevel = (Double)MajoSpellEnchantmentConfig.manaReaperRegenCapPerLevel.get();
        double manaRestore = mobMaxHealth * factor;
        double cap = capPerLevel * (double)enchantLevel;
        if ((manaRestore = Math.min(manaRestore, cap)) <= 0.0) {
            return;
        }
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        magicData.addMana((float)manaRestore);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncManaPacket(magicData), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

